window.LanguageManager = window.LanguageManager || {};

(function() {
  var LanguageManager = window.LanguageManager;

  LanguageManager.initLanguage = function() {
    if (!document.getElementById("GobalSelectLanguage")) {
      setTimeout(LanguageManager.initLanguage, 100);
      return;
    }
    
    var savedLang = localStorage.getItem('userLanguage');
    if (savedLang) {
      document.getElementById("GobalSelectLanguage").value = savedLang;
    }

    var selectLang = document.getElementById("GobalSelectLanguage");
    var langIndex = parseInt(selectLang.value, 10);
    var langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
    var translations = window.languages[langCode];

    if (!translations) {
      return;
    }
    LanguageManager.InitLanguageOfPage();
    LanguageManager.InitLanguageOfMenu();
  };

  LanguageManager.changeLanguage = function(lang) {
    var selectElement = document.getElementById("GobalSelectLanguage");
    if (!selectElement) {
      console.log("Step 20: selectElement not found, exiting");
      return;
    }
    
    if (lang !== undefined) 
    {
      selectElement.value = lang;
      localStorage.setItem('userLanguage', lang);
    }
    LanguageManager.InitLanguageOfPage();
    LanguageManager.InitLanguageOfMenu();
  };

  // 更新選單文字
  LanguageManager.InitLanguageOfMenu = function() {
    var selectLang = document.getElementById("GobalSelectLanguage");
    if (!selectLang) {
      console.log("Step 28: selectLang not found, exiting");
      return;
    }
    
    var langIndex = parseInt(selectLang.value, 10);
    var langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
    var translations = window.languages[langCode];
    
    if (!translations) {
      return;
    }
    
    var menuItems = {
      "Menu_Settings": document.getElementById("menuSettings"),
      "Menu_Device": document.getElementById("menuDevice"),
      "Menu_Network": document.getElementById("menuNetwork"),
      "Menu_Security": document.getElementById("menuSecurity"),
      "Menu_Maintenance": document.getElementById("menuMaintenance")
    };
    
    for (var key in menuItems) 
    {
      if (menuItems[key] && translations[key]) 
      {
        menuItems[key].textContent = translations[key];
      }
    }
  };

  LanguageManager.getTranslatedText = function(key) {
    var selectLang = document.getElementById("GobalSelectLanguage");
    if (!selectLang) {
      console.log("!selectLang ---> key",key);
      return key;
    }

    var langIndex = parseInt(selectLang.value, 10);
    var langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
    var translations = window.languages[langCode];

    if (!translations) {
      console.log("!translations ---> key",key);
      return key;
    }

    return translations[key] || key;
  };

  LanguageManager.InitLanguageOfPage = function() {
    var selectLang = document.getElementById("GobalSelectLanguage");
    if (!selectLang) {
      return;
    }
    
    var langIndex = parseInt(selectLang.value, 10);
    var langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
    var translations = window.languages[langCode];
    
    if (!translations) {
      console.log("Step : Translations not available, exiting");
      return;
    }

    try {
      document.querySelectorAll("[id^='A_tab'], [id^='Label_'], [id^='Span_'], [id^='BLS_'], #Label_Settings").forEach(function(element) {
        if (translations[element.id]) {
          element.textContent = translations[element.id];
        }
      });
    } catch (e) {
      console.warn("Step : Error updating text elements:", e);
    }

    try {
      var videoButton = document.getElementById("videoOnOffButton");
      if (videoButton) 
      {
        if (typeof gIsVideoStart !== "undefined") 
        {
          videoButton.textContent = gIsVideoStart
            ? translations["Stop_Video_Output"]
            : translations["Start_Video_Output"];
        }
      }
    } catch (e) {
      console.warn("Step : Error updating dynamic buttons:", e);
    }

    try {
      document.querySelectorAll("button").forEach(function(button) {
        if (!button || !button.textContent) return;
        var buttonText = button.textContent.trim();
        if (["Apply", "確認", "确认"].includes(buttonText)) {
          button.textContent = translations["Apply"] || "Apply";
        } else if (["Cancel", "取消"].includes(buttonText)) {
          button.textContent = translations["Cancel"] || "Cancel";
        } else if (["OK", "確定", "确定"].includes(buttonText)) {
          button.textContent = translations["OK"] || "OK";
        } else if (button.id && translations[button.id]) {
          button.textContent = translations[button.id];
        } else if (button.id && button.id.startsWith("Btn") && translations[button.id.substring(3)]) {
          button.textContent = translations[button.id.substring(3)];
        }
      });
    } catch (e) {
      console.warn("Step 52: Error updating buttons:", e);
    }

    try {
      document.querySelectorAll("[id^='BackToHomeSetting_']").forEach(function(element) {
        var index = element.id.split("_")[1]; // 提取索引
        element.textContent = LanguageManager.getTranslatedText("Back_to_Home");
      });
      document.querySelectorAll("[id^='TimetoTriggerPreset_']").forEach(function(element) {
        var index = element.id.split("_")[1]; // 提取索引
        element.textContent = LanguageManager.getTranslatedText("Time_To_Trigger_Preset");
      });
      document.querySelectorAll("[id^='AudioTriggerLevel_']").forEach(function(element) {
        var index = element.id.split("_")[1]; // 提取索引
        element.textContent = LanguageManager.getTranslatedText("Audio_Trigger_Level_dB");
      });
      document.querySelectorAll("[id^='Label_DeviceConnect']").forEach(function(element) {
        var index = element.id.split("_")[1];
        element.textContent = LanguageManager.getTranslatedText("Connect");
      });
      document.querySelectorAll("[id^='Label_DevicePort']").forEach(function(element) {
        var index = element.id.split("_")[1];
        element.textContent = LanguageManager.getTranslatedText("Port");
      });
      document.querySelectorAll("[id^='BtnModelBackToHomeSetting_']").forEach(function(element) {
        var index = element.id.split("_")[1];
        element.textContent = LanguageManager.getTranslatedText("Set");
      });
      document.querySelectorAll("[id^='zoneModeSetting_']").forEach(function(element) {
        var index = element.id.split("_")[1];
        element.textContent = LanguageManager.getTranslatedText("Zone_Setting");
      });
      document.querySelectorAll("[id^='Label_Azimuth_Qty_']").forEach(function(element) {
        var index = element.id.split("_")[1];
        element.textContent = LanguageManager.getTranslatedText("Mapping_Qty");
      });
    } catch (e) {
      console.warn("Step : Error updating BackToHomeSetting labels:", e);
    }
    
    try {
      document.querySelectorAll("select:not(#GobalSelectLanguage)").forEach(function(select) {
        Array.from(select.options).forEach(function(option) {
          var langKey = option.getAttribute("data-lang");
          if (langKey && translations[langKey]) {
            option.text = translations[langKey];
          }
        });
      });
    } catch (e) {
      console.warn("Step : Error updating select options:", e);
    }
  };

  LanguageManager.gSelectLang = document.getElementById("GobalSelectLanguage");

  LanguageManager.ginitializeLanguageSupport = function() 
  {
    if (!window.languages) return;
    LanguageManager.initLanguage();
    const select = document.getElementById('GobalSelectLanguage');
    if (select) 
    {
      select.addEventListener('change', () => LanguageManager.changeLanguage(select.value));
    }
  };

  document.addEventListener('DOMContentLoaded', LanguageManager.ginitializeLanguageSupport);

})();

const languages = {
    en: {
      Label_Settings: "Settings",
      Span_MenuSettings: "Settings",
      Menu_Device: "Device",
      Span_MenuNetwork: "Network",
      Label_Network: "Network",
      Menu_Security: "Security",
      Menu_Maintenance: "Maintenance",
      Label_Language: "Language",
      Apply: "Apply",
      Cancel: "Cancel",
      OK:"OK",
      A_tabDevice: "Device",
      A_tabAutoConnection: "Auto Connection",
      A_tabDante: "Dante",
      A_tabExtensionSetup: "Extension Setup",
      BC200_Setup_Mode: "BC-200 Calibration Setup Mode",
      A_tabWebUser: "Web User",
      A_tabMaintenance: "Maintenance",
      Label_tabOptimization:"Optimization",
      Label_tabBetaFunctions:"Beta Functions",
      Label_tabScheduleReboot: "Schedule Reboot",
      Label_DebugMode:"Debug Mode",
      Label_Activate_the_log_collection:"Activate the log collection control on the Microphone page.",
      Label_After_applying_the_settings:"After applying the settings, the Debug control items will be displayed on the configuration page.",
      
      Span_MenuAbout: "About",
      ActiveData: "ActiveData",
      Add: "Add",
      Address: "Address",
      Administrator: "Administrator",
      Advanced: "Advanced",
      Span_MenuStreamAIDirector: "Intelligent Director",
      Label_Intelligence_Director:"Intelligent Director",
      AI_Setting: "AI Setting",
      All_Camera: "All",
      All_Mic_off_Stream: "All Mic off Stream",
      ALL_XY_Mode: "ALL XY Mode",
      Area: "Area",
      Label_Array_Microphone: "Array Microphone",
      Array_Microphone: "Array Microphone",
      Label_Arrary_Microphone_Numbers: "Array Microphone Numbers",
      Array_No: "Array No.",
      Audio_to_USB_output: "Audio to USB output",
      Audio_Trigger: "Audio Trigger",
      Label_Nimble_ear_audio_trigger_title:"Audio Trigger (dB)",
      Audio_Trigger_Level: "Audio Trigger Level > dB",
      Audio_Trigger_Level_dB: "Audio Trigger Level (dB)",
      Auto_Check: "Auto Check",
      Auto_Connection: "Auto Connection",
      Label_Auto_Run: "Auto Run",
      Run:"Run",
      Auto_Save: "Auto Save",
      AutoSave_Interval: "AutoSave Interval",
      Label_layoutTypeSelect_Auto:"Auto",
      Label_layoutTypeSelect_Custom:"Custom",
      Label_Auxiliary_Camera: "Auxiliary Camera",
      Label_BC200_Label_Cameraname: "Auxiliary Camera",
      Auzimuth_Angle: "Auzimuth Angle",
      Awaiting: "Awaiting",
      Pending: "Pending",
      Back: "Back",
      Home: "Home",
      Back_to_Home: "Back to Home",
      Back_to_Home_Time: "Back To Home Time (s)",
      Back_to_Home_Camera:"Back To Home Camera",
      Back_to_Home_Position:"Back To Home Position",
      Call_AB_Preset_Cruise: "Call A B Preset Cruise",
      Call_CAM: "Call CAM",
      CAM: "CAM",
      Camera: "Camera",
      Camera_Calibration: "Camera Calibration",
      Calibration: "Calibration",
      Camera_Control_Status: "Camera Control & Status",
      Label_PTZ_Control:"PTZ",
      Label_Cameralist: "Camera List",
      Span_MenuStreamCameraList: "Camera List",
      Center_Stage: "Center Stage",
      BtnCheckUpdated:"Check",
      Check: "Check",
      Clear_All: "Clear All",
      Clear_Log: "Clear Log",
      Label_Clear_Log: "Clear Log",
      Configure_File: "Configure File",
      Confirm_Password: "Confirm Password",
      Label_CameraList_Connect: "Connect",
      Label_BC200_Label_Connect: "Connect",
      Connect: "Connect",
      Connect_Error: "Connect Error",
      Ready: "Ready",
      Connected: "Connected",
      Unconnect:  "Disconnected",
      Disconnected: "Disconnected",
      Disconnecting: "Disconnecting",
      Connecting: "Connecting",
      Continue_Tracking: "Continue Tracking",
      Conversation: "Conversation",
      Conversation_Mode: "Conversation Mode",
      Crop: "Crop",
      Span_LayoutCrossCrop:"Crop",
      Cross: "Cross",
      Label_layoutTypeSelect_Cross: "Cross",
      Cruise: "Cruise",
      Cruise_Mode: "Cruise Mode",
      Current_Password: "Current Password",
      Customize: "Customize",
      Customize_X: "Customize X",
      Customize_1: "Customize 1",
      Customize_2: "Customize 2",

      Decvice_IP: "Decvice IP",
      Sec: "Sec",
      Label_Sec: "Sec",
      deg_sec: "deg/sec",
      Delay: "Delay",
      delay_X_milliseconds: "delay X milliseconds",
      delay_X_minutes: "delay X minutes",
      delay_X_seconds: "delay X seconds",
      deleteButton: "Delete",
      Label_Nimble_detetcive_time_title: "Detection Time (s)",
      Label_Device_Camera_Mapping: "Device & Camera Mapping",
      Camera_Mapping: "Camera Mapping",
      Label_Device_Name: "Device Name",
      Label_System_Startup_Waiting_Time: "System Startup Waiting Time",
      Label_System_Startup_Waiting_Time_Hint: " Min (3~99)", 
      Label_Visca_WaitingAck_Time: "Visca Waiting Ack Time",
      Label_Visca_WaitingAck_Time_Hint: " Sec (0~10)", 
      Label_Nimble_Eye_Triger_Stable_Range:"BC-200 mutual trigger detection Range",
      Label_Nimble_Eye_Triger_Stable_Range_Hint: "m (0.1 ~ 5 , 0 is off)",
      Label_Nimble_Eye_Dection_Range:"BC-200 display detection Range",
      Label_Nimble_Eye_Dection_Range_Hint: "m (0.1 ~ 5 , 0 is off)",
      Label_Nimble_Eye_Show_Box: "BC-200 displays human detection frame",
      Label_CameraList_Source_Name: "Source Name",
      Device_Numbers: "Device Numbers",
      Span_MenuDevices: "Devices",
      Devices: "Devices",
      Device: "Device",
      Label_Microphone_DeviceType: "Device",
      Device_IP: "Device IP",
      Label_Microphone_DeviceIP:"Device IP",
      Director_Mode_Loading: "Director Mode & Microphone Setting is Loading …",
      Label_Microphone_Setting:"Microphone Setting",
      Disk_Check: "Disk Check",
      Label_DNS: "DNS",
      do: "do",
      Edit: "Edit",
      Label_Intelligence_Director_Edit:"Edit",
      Enable: "Enable",
      Enable_Zone: "Enable Zone",
      Error_Notification: "Error Notification",
      Event_Log: "Event Log",
      Exclusion_Mode: "Exclusion Mode",
      execution: "execution",
      Label_Intelligence_Director_Execution_Log: "Execution Log",
      BtnExportLog: "",
      Export: "Export",
      Export_Log: "Export Log",
      Export_Script: "Export Script",
      Extension: "Extension",
      Extension_Setup: "Extension Setup",
      Setup: "Setup",
      Label_File_Saved_Time: "File Saved Time",
      Firmware_OTA: "Firmware OTA",
      Firmware_Update: "Firmware Update",
      Firmware_Version: "Firmware Version",
      Label_Gateway: "Gateway",
      ID: "ID",
      Import: "Import",
      Import_Script: "Import Script",
      Information: "Information",
      Interval: "Interval",
      IP: "IP",
      Label_BC200_Label_IP: "IP",
      IP_USB: "IP / USB",
      Label_IPAddress: "IP Address",
      IPv4: "IPv4",
      Layout: "Layout",
      Label_LayoutType2:"Layout",
      Layout_Type: "Layout Type",
      Label_LayoutType:"Layout Type",
      Leave: "Leave",
      Load: "Load",
      mode: "mode",
      Profile:"Profile",
      Save_Success:"Save Success!!",
      Saving_Profile:"Saving Profile",
      data:"data",
      Span_Load_Profile: "Load Profile",
      Label_Profile_Index:"Profile ID :",
      Label_Location: "Location",
      Label_Account: "Login Role :",
      Loop_Script: "Loop Script",
      Label_MacAddress: "MAC Address",
      Label_About_MACAddress:"MAC Address :",
      Label_Manual_IP: "Manual IP",
      Label_Nimble_ManualIPText: "Manual IP",
      Label_Manufacturer: "Manufacturer :",
      Mapping_Qty: "Mapping Qty.",
      Label_Max_Microphone_Qty: "Max Microphone Qty.",
      Method: "Method",
      Label_Method:"Method",
      Mic_Zone: "Mic. Zone",
      Label_BC200_Label_Assign: "Mic.Assign",
      Assign: "Assign",
      Label_BC200_Camera_Calibration: "Camera Calibration",
      Span_BC200_Camera_Calibration: "Camera Calibration",
      Span_Microphone_BC200_Camera_Calibration: "Overview Mapping",
      Span_Microphone_BC200_Camera_Calibration_Upload:"Calibration File Upload",
      Microphone: "Microphone",
      Span_MenuStreamMicrophone:  "Microphone",
      Microphone_Setting: "Microphone Setting",
      Min: "Min",
      Minute: "Min",
      m:"m",
      Zone_Mode: "Zone Mode",
      Mic_Zone_Information: "Mic. Zone Information",
      Label_Model_Name: "Model Name :",
      Label_Netmask: "Netmask",
      New_Password: "New Password",
      Label_File_Saved_No: "No.",
      Notice_Camera: "Notice : Camera connecdtion error, please check camera status.",
      Operation: "Operation",
      Label_CameraList_Operation: "Operation",
      Label_Nimble_ptz_camera_trigger_title: "PTZ Camera Trigger",
      Password: "Password",
      Label_Password: "Password",
      PBP: "PBP",
      Label_layoutTypeSelect_PBP: "PBP",
      Port: "Port",
      Pos: "Pos.",
      Position_X: "Position X",
      Label_CameraPos1:"Position 1",
      Label_CameraPos2:"Position 2",
      Label_CameraPos3:"Position 3",
      Label_CameraPos4:"Position 4",
      Presenter: "Presenter",
      Preset: "Preset",
      Preset_X_end: "Preset X end",
      Preset_X_start: "Preset X start",
      end: "end",
      start: "start",
      Preset_No: "Preset No.",
      Preset_Speed: "Preset Speed",
      Preset_Speed_X: "Preset Speed X",
      Primary_Camera: "Primary Camera",
      Span_MenuProfiles: "Profile",
      Label_MirrorProfile:"Profile :",
      Label_Profile: "Profile",
      Label_Profiles_Title: "Profile",
      Label_Profile_List: "Profile List",
      Label_Profile_Name: "Profile Name :",
      Profile_Setting: "Profile Setting",
      Profiles: "Profiles",
      range: "range",
      Reboot: "Reboot",
      Reference_Audio: "Reference Audio",
      Label_Reference_AudioInput: "Reference Audio Input",
      Reference_Video: "Reference Video",
      Repeat_Count: "Repeat Count",
      Reschedule_in_1: "Reschedule in",
      Reschedule_in_2: "seconds",
      Reschedule_in_X_seconds: "Reschedule in X seconds",
      Reschedule_in: "Reschedule in",
      Reset: "Reset",
      Resolution: "Resolution",
      Label_Resolution:"Resolution",
      Run: "Run",
      Label_AIDirector_Run: "Run",
      s: "s",
      Span_Store: "Store",
      Store: "Store",
      Save: "Save",
      Span_Save_As_New_Profile: "Save as New Profile",
      Script_End: "Script End",
      Script_Start: "Script Start (Priority:",
      Start: "Start",
      Script_Stop: "Script Stop",
      Seamless_Switching: "Seamless Switching",
      Seamless_Switch: "Seamless Switch",
      Label_SeamlessSwitching: "Seamless Switching",
      Secondary_Camera: "Secondary Camera",
      Auxiliary_Camera:"Auxiliary Camera",
      Select_Camera_Amout: "Select Camera Amout",
      Select_Microphone_Channel: "Select Microphone Channel",
      Select_Video_Layout: "Select Video Layout",
      Select_Video_Layout_Mode: "Select Video Layout Mode",
      Send_HEX_Commands: "Send HEX Commands",
      Label_SerialNumber: "Serial Number :",
      Set: "Set",
      Set_CAM: "Set CAM",
      CAM: "CAM",
      Setting_Error: "Setting Error",
      Settings: "Settings",
      Software_Update: "Software Update",
      Sound_Device: "Sound Device",
      Source_Name: "Source Name",
      Source_Position: "Source Position",
      Label_SourcePosition: "Source Position",
      Start_Video_Output: "Start Video Output",
      Stop_Video_Output: "Stop Video Output",
      Static_IP: "Static IP",
      Label_Static_IP: "Static IP",
      Label_BC200_Label_Status:"Status",
      Label_CameraList_Status: "Status",
      Stop: "Stop",
      Supported_Devices_Settings: "Supported Devices & Settings",
      Span_MenuSystem: "System",
      System_Factory: "System Factory",
      System_Startup_Waiting_Time: "System Startup Waiting Time",
      Trigger_count: "Trigger count",
      BtnOfflineUpdate: "Upgrade",
      User_Name: "User Name",
      Version: "Version",
      Label_Video_Channel_Qty: "Video Channel Qty.",
      Video_Output: "Video Output",
      Video_Output_Layout: "Video Output Layout",
      Label_VideoOutputMode: "Video Output Mode",
      Span_MenuVideoOutputSetting: "Video Output Setting",
      Label_VideoOutputSetting:"Video Output Setting",
      Video_Source_Position: "Video Source to Position",
      By_Cam:"by CAM",
      Video_Switching_Mode: "Video Switching Mode",
      Label_Vision_Zone_Detection_title: "Vision Zone Detection",
      Voice_range_Height: "Voice range Height",
      Voice_range_Width: "Voice range Width",
      Voice_Source_Detect: "Voice Source Detect",
      Label_SetVoiceTracking: "Voice Tracking",
      Voice_Tracking_Area_range: "Voice Tracking Area range",
      Label_Nimble_ear_volume_value_title: "Volume Value",
      Web_User: "Web User",
      Zone: "Zone",
      Zone_No: "Zone No.",
      Zone_Setting: "Zone Setting",
      Zone_Full_Map: "Mapping Overview",
      Zone_Map: "Zone Map",
      Label_SoundDevice: "Sound Device",
      Label_Camera: "Camera",
      Label_VideoOutput: "Video Output",
      Label_Interval: "Interval",
      Label_user: "User Name",
      Label_pass1: "Current Password",
      Label_pass2: "New Password",
      Label_pass3: "Confirm Password",
      Label_DanteEnable: "Enable",
      Label_DanteUacEnable: "Audio to USB output",
      Label_ConfigureFile: "Configure File",
      Label_Firmware_Version: "Firmware Version :",
      Label_CurFirmwareVer: "Firmware Version :",
      Label_OtaAutoCheck: "Auto Check",
      Label_OfflineFirmware: "Firmware Update",
      Label_ExportLog: "Event Log",
      Label_Reboot: "Reboot",
      Label_SystemFactory: "System Factory",
      Span_Import: "Import",
      Span_Export: "Export",
      Label_Export: "Export",
      Span_Reset: "Reset",
      Span_Apply: "Apply",
      Zoom:"Zoom",
      Mirror_Flip:"Mirror / Flip",
      Mirror_add_Flip:"Mirror + Flip",
      Mirror:"Mirror",
      Flip:"Flip",
      OFF:"OFF",
      Off:"Off",
      AF_MF:"AF/MF",
      Label_AFMF:"AF/MF",
      Focus:"Focus",
      Label_FocusPlus:"Focus+",
      Label_FocusMinus:"Focus-",
      Label_DeviceAPIKey:"API Access Key",
      Label_VoiceTrackingTooltip:"In this mode, the camera source and presets do not switch or change.",
      Director_Mode_Profile_is_loading:"Director Mode & Profile is loading ",
      Director_Mode_Microphone_Setting_is_loading:"Director Mode & Microphone Setting is loading",
      Configuration_initialization_in_progress:"Configuration initialization in progress ...",
      Label_powerOffMsg:"The system is processing. Please try againg later.",
      web_page_connection_has_failed:"The web page connection has failed, please reload the page …",
      web_page_controlByGUI:"The device is currently being operated through the HDMI interface.Please try again later when local control is no longer active.",
      The_power_during_the_firmware_update:"Please do not remove the power during the firmware update",
      Please_wait:"Please wait …",
      Label_Intelligence_Director_Result:"Result :",
      Label_Intelligence_Director_Script_Result:"Result :",
      Label_Execution_Script:"Execution Script",
      Label_Script_Leave :"Leave",
      Label_Import_Script :"Import Script",
      Label_Script_Save :"Save",
      Label_Export_Script :"Export Script",
      Label_Script_Save_File_Success :"Save File Success!",
      Label_Script_Stop :"Stop",
      Stop :"Stop",
      Label_Script_Run :"Run",
      Label_Script_Execution_Log :"Execution Log",
      Label_Script_Clear_Log :"Clear Log",
      Label_Script_Export_Log :"Export Log",
      Label_PTZCameraView_Title:"PTZ Camera",
      Label_BC200CameraView_Title:"Auxiliary Camera",
      Select_Camera:"Select Camera",
      Select_Camera_Preset:"Select Camera Preset",
      Select_CameraZoomRatio:"Select Camera Zoom Ratio",
      Pan_Tilt_Reset:"Pan / Tilt Reset",
      Coordinate_Calbriatoin_Center: "Coordinate Calibration Center ( Pan / Tilt ) : ",
      Coordinate_Calbriatoin_Center_Zoom: "Coordinate Calibration Center ( Pan / Tilt / Zoom) : ",
      null:"null",
      No_cameras_available:"Off",//"No cameras available",
      The_file_is_not_valid:"The file is not valid",
      OffLine_OTA_Hint:   "The system will shut down automatically once the update process is complete. <br>"
                        + "Please POWER ON or re-plug the power after the shutdown process is finished!! <br>"
                        + "You can check the update status through HDMI output.<br>",
      Microphone_Assign_List:"Microphone Assign List",
      Number: "Number",
      Angle_Location_Direction:"Angle/Location/Direction",
      Span_Add:"Add",
      Span_Set:"Set",
      Span_Setup:"Setup",
      Span_Upload:"Upload",
      Check_error_please_check_network_status:"Check error, please check network status.",
      System_Process_Failed: "System process failed. Please verify the network status and settings.",
      Wait_For_Version_Check: "Wait for version check.",
      Reset_To_Default_And_Reboot: "Are you sure you want to reset to default value and reboot the system?",
      Reset_To_Default_And_Auto_Reboot: "Are you sure you want to reset the system to default and reboot automatically?",
      PTZ_Control_Available_When_Connected: "PTZ control is available only when the camera is connected.",
      Intelligence_Director_Mode_Active: "Intelligent Director Mode is currently active. Controls and settings are unavailable.",
      Shut_Down_System: "Are you sure you want to shut down the system?",
      Wait_For_Reboot: "Wait for reboot.",
      Wait_For_Dante_Settings: "Wait for Dante settings.",
      System_Temperature_Overheating: "Notice: System temperature is overheating!",
      Check_Installation_Environment: "Please check installation environment and refer troubleshooting guide from user manual to resolve.",
      Contact_Lumens_Support: "Or contact Lumens Support by scanning the QR code.",
      Description_Of_Update: "Description of the update:",
      Waiting_For_System_Files_Update: "Waiting for system files to update…",
      Version_Up_To_Date: "Your current version is up to date.",
      System_Initializing: "System Initializing…",
      Update_Available: "Update Available",
      Newer_CamConnect_Version: "A newer version of CamConnect Processor is available.",
      Update_Now: "Update Now",
      Span_Update_Now: "Update Now",
      Later: "Later",
      Span_Later: "Later",
      Release_Notes: "Release Notes",
      Span_Release_Notes: "Release Notes",
      Done: "Done",
      Auto_Reboot_After_Update: "The system will automatically reboot after the update is complete.",
      Updating: "Updating :",
      Call_Camera:"Call Camera",
      Call:"Call",
      Back_To_Home:"back to home",
      Conversation_Mode_for_1_by_2_Layout:"Conversation Mode for 1 by 2 Layout",
      milliseconds:"milliseconds",
      s: "seconds",
      seconds: "seconds",
      min:"min",
      minutes: "minutes",
      Microphone_Select:"Microphone Select",
      Call_camera_preset_with_range:"Call camera preset with range",
      Send_HEX_Commands:"Send HEX Commands",
      Send_VISCA_Command:"Send VISCA Command",
      Script_next_execution:"Script next execution",
      Time_to_Mute: "Time to Mute",
      Time_to_Trigger: "Time to Trigger",
      Time_To_Trigger_Preset: "Time To Trigger Preset",
      Status: "Status",
      Cruise_Mode_for_1_by_3_Layout:"Cruise Mode for 1 by 3 Layout",
      Select_channel:"Select channel",
      Select_Camera_Amount:"Select Camera Amount",
      Cruise_Mode:"Cruise Mode",
      X_Y:"X -> Y",
      X_start_X_end_Y_start_Y_end:"X start -> X end -> Y start -> Y end",
      Please_wait_for_the_streaming_screen:"Please wait while the streaming screen is loading…",
      Span_Administrator:"Administrator",
      Viewer:"Viewer",
      Trigger_Time: "Trigger Time (s)",
      Camera_Selection:"Camera Selection",
      Position_Type:"Position Type",
      Camera_and_BC200_Calibration:"Select the camera installed with the BC-200.",
      Are_you_sure_you_want_to_reboot_the_system :"Are you sure you want to reboot the system?",
      PTZ_Control_only_available_while_camera_is_connected:"PTZ Control only available while camera is connected.",
      File_loaded_successfully:"The file has been successfully loaded!",
      File_loaded_XML_Failed:"Failed to load XML file!",
      Config_Import_Success: "The file configuration import has succeeded.<br>Please wait for the system to restart, which will take approximately 3 minutes.<br>Once the system has restarted, please refresh your browser and log in again.",
      Dante_Activation_Data_Backup: "Dante Activation Data Backup",
      Dante_Activation_Message: "The process of saving and exporting Dante activation data is crucial to ensure seamless device operation.<br>Regular backups help prevent authentication failures in case of device replacements or unforeseen issues.<br>Manual backups are recommended for enhanced reliability and data security.",
      Dante_Activation_Instructions: "(Go to the System Tab > Settings > Dante, and click “Export” under ActivationData.)",
      Do_Not_Notify_Next_Time: "Understood, please do not notify me next time.",
      BC200ConnectError: "This BC-200 is not in the connection list. <br>Please recheck whether the connection is normal <br>and confirm that the device is not an 「 Unknown 」 device.",
      Please_wait_for_the_canvas_file_to_loading:"Please wait for the canvas file to loading...",
      Retrying_to_get_canvas_file_A:"Retrying to get canvas file for the",
      Retrying_to_get_canvas_file_B:"st time",
      Retrying_to_get_canvas_file_C:"(maximum",
      Retrying_to_get_canvas_file_D:"times)",
      Retrying_to_get_canvas_file_End:"Unable to retrieve canvas file, please close the window and try again",
      Camera_Get_BC200_No:"Camera stream is currently obtained, but BC-200 stream is not obtained. Retrying to acquire BC-200 stream.",
      Camera_No_BC200_Get:"The BC-200 stream has been acquired, but the camera stream is still unavailable. Retrying to acquire the camera stream.",
      Camera_No_BC200_NO:"Neither camera stream nor BC-200 stream is currently obtained. Retrying to acquire all streams.",
      Please_wait_for_the_camera_calibration_to_save: "Please wait for the camera calibration data to be saved.",
      Camera_calibration_pan_tilt_is_not_save:"Calibration data for this camera has not been saved.",
      Wait_Get_Sound_data: "Please wait for the microphone page data to be synchronized.",
      Wait_get_extension_setup_data: "Please wait get extension setup data read.",
      Label_powerStandByModeMsg:"The system is in standby mode. Please press the power button to reboot the system.",
      Processing_Request:"Processing request.Please wait ...",
      BLS_Parameters_Label: "Parameters",
      BLS_NoiseLevelThreshold_Label: "Noise Level Threshold",
      BLS_NoiseLevelThreshold_Tooltip: "Sets the noise threshold multiplier. Range: 100.0 ~ 300.0 (100.0 for quiet environments, 300.0 for noisy).",
      BLS_XAxisDistanceDiff_Label: "X-Axis Distance Difference",
      BLS_XAxisDistanceDiff_Tooltip: "Threshold for X-axis position change. Range: 10 ~ 50 (10 for small movements, 50 to ignore minor shifts).",
      BLS_YAxisDistanceDiff_Label: "Y-Axis Distance Difference",
      BLS_YAxisDistanceDiff_Tooltip: "Threshold for Y-axis position change. Range: 10 ~ 50 (10 for small movements, 50 to ignore minor shifts).",
      BLS_SoundIntensityDiff_Label: "Sound Intensity Difference",
      BLS_SoundIntensityDiff_Tooltip: "Threshold for sound intensity change. Range: 1 ~ 5 (1 for small changes, 5 to ignore minor fluctuations).",
      BLS_MicSelectionTime_Label: "Microphone Selection Time",
      BLS_MicSelectionTime_Tooltip: "Minimum time interval for mic selection. Range: 20 ~ 100 (20 for fast response, 100 for stability).",
      BLS_HistorySize_Label: "History Size",
      BLS_HistorySize_Tooltip: "Score history window size. Range: 1 ~ 5 (1 for no smoothing, 5 for strong smoothing).",
      BLS_MicSwitchThreshold_Label: "Microphone Switch Threshold",
      BLS_MicSwitchThreshold_Tooltip: "Threshold for mic switching. Range: 0.9 ~ 1.3 (0.9 for easy switching, 1.3 for stability).",
      BLS_DistanceWeight_Label: "Distance Weight",
      BLS_DistanceWeight_Tooltip: "Weight of distance in score calculation. Range: 0.3 ~ 0.7 (0.5 balanced, 0.7 emphasizes distance).",
      BLS_SoundIntensityWeight_Label: "Sound Intensity Weight",
      BLS_SoundIntensityWeight_Tooltip: "Weight of sound intensity in score calculation. Range: 0.3 ~ 0.7 (0.5 balanced, 0.7 emphasizes dB).",
      BLS_NumberOfInputs_Label: "Number of Inputs",
      BLS_NumberOfInputs_Tooltip: "Number of BLS model input features. Range: 9 ~ 12 (9 for simpler model, 12 includes phiAngle).",
      BLS_FeatureNodes_Label: "Feature Nodes",
      BLS_FeatureNodes_Tooltip: "Number of BLS model feature nodes. Range: 6 ~ 16 (6 for low cost, 16 for high precision).",
      BLS_EnhanceNodes_Label: "Enhance Nodes",
      BLS_EnhanceNodes_Tooltip: "Number of BLS model enhance nodes. Range: 6 ~ 16 (6 for low cost, 16 for high precision).",
      BLS_MaxTracksSize_Label: "Max Tracks Size",
      BLS_MaxTracksSize_Tooltip: "Maximum number of tracking data. Range: 5 ~ 20 (5 for dynamic scenes, 20 for static scenes).",
      BLS_MicDataSaveWindowSize_Label: "Mic Data Save Window Size",
      BLS_MicDataSaveWindowSize_Tooltip: "Window size for historical dB and position data. Range: 3 ~ 10 (3 for dynamic scenes, 10 for static scenes).",
      Debug_Mode_Data_save:"Waiting for debug mode data to be saved.",
      BLS_Select_Environment: "Select Environment",
      BLS_Select_Environment_Default: "Default",
      BLS_Select_Environment_QuietOffice: "Quiet Office",
      BLS_Select_Environment_NoisyCafe: "Noisy Cafe",
      BLS_Select_Environment_ConferenceRoom: "Conference Room",
      BLS_Select_Environment_LargeLectureHall: "Large Lecture Hall",
      BLS_Select_Environment_OutdoorEvent: "Outdoor Event",
      BLS_Select_Environment_RecordingStudio: "Recording Studio",
      BLS_Select_Environment_TelemedicineClinic: "Telemedicine Clinic",
      BLS_Environment_Default_Tooltip: "Features: High noise threshold (200.0), short distance difference (20), high distance weight (0.8), suitable for general meeting rooms or dynamic environments. Reason: Provides balanced settings for most environments, emphasizing spatial positioning for quick adaptation to various scenarios.",
      BLS_Environment_QuietOffice_Tooltip: "Features: Low noise threshold (120.0), medium distance difference (25), higher distance weight (0.6), fast microphone selection (40ms). Reason: Optimized for quiet environments, reducing noise sensitivity to focus on clear speech, with fast switching for efficient single-speaker scenarios.",
      BLS_Environment_NoisyCafe_Tooltip: "Features: High noise threshold (200.0), large distance difference (40), high sound intensity weight (0.6), longer history record (4). Reason: Designed for noisy environments, high threshold filters background noise, emphasizing sound intensity for stable primary voice detection.",
      BLS_Environment_ConferenceRoom_Tooltip: "Features: Medium noise threshold (160.0), medium distance difference (35), balanced weights (0.5/0.5), standard history record (3). Reason: Ideal for typical conference rooms, balancing noise and positioning needs for stable switching and clear audio.",
      BLS_Environment_LargeLectureHall_Tooltip: "Features: Higher noise threshold (180.0), large distance difference (45), more feature nodes (14), large tracking data (18). Reason: Suited for large spaces, allowing wider movement ranges, with high-precision models supporting multi-person and long-distance voice capture.",
      BLS_Environment_OutdoorEvent_Tooltip: "Features: Very high noise threshold (220.0), maximum distance difference (50), high sound intensity weight (0.7), maximum tracking data (20). Reason: Addresses outdoor noise, ignores minor movements, and emphasizes sound intensity for primary voice capture in dynamic scenes.",
      BLS_Environment_RecordingStudio_Tooltip: "Features: Very low noise threshold (100.0), small distance difference (20), high distance weight (0.7), shortest history record (1). Reason: Optimized for high-quality recording, highly sensitive to subtle sounds with fast response and precise positioning for pure audio.",
      BLS_Environment_TelemedicineClinic_Tooltip: "Features: Low noise threshold (110.0), small distance difference (22), higher distance weight (0.65), minimal tracking data (6). Reason: Designed for single-speaker conversations, low threshold ensures clear voice, with precise positioning and fast switching for medical dialogues.",
      Span_Import:"Import",
      Span_Export:"Export",
      Label_Debug_Mode:"Debug Mode",
      Label_Parameter_Mode:"Parameter adjustment Mode",
      Label_Execution_Header:"Execution Messages",
      Span_Clear_Message:"Clear Debug Message",
      Span_Output_Message:"Output Debug Message",
      Enter_file_name_to_save:"Please enter the name of the file you want to save.",
      No_Switch:"Off",
      Conversation_Rules:"Conversation Mode rules",
      Position_Index: "Pos.",
      Enter_Switch_Time: "Enter Time",
      Exit_Switch_Time: "Exit Time", 
      Enter_Switch_Count: "Count of triggers",
      Exit_Switch_Count: "Count of mutes",
      Control_Panel:"Control Panel",
      Label_DisableSchedule: "Disable Schedule",
      Label_DailyRebootHint: "(Available when CamConnect is connected to a network and synchronized with an NTP server.)",
      Label_RebootTiming:"Reboot Timing",
      Label_RebootTimingHint: "(Available when CamConnect is used without a network connection. Uses the system startup time for the reboot schedule.)",
      Label_PipMode: "PIP",
      Remember_Me:"Remember Me",
      User_Name:"User Name",
      LogIn:"Log in",
      Please_enter_your_username:"Please enter your username",
      Please_enter_your_password:"Please enter your password",
      Username_saved:"Username saved",
      Viewer_LogIn:"Viewer Login",
      Username_admin:"Administrator",
      Username_viewer:"Viewer",
      Login_Failed:"Login Failed",
      Please_change_your_password:"Please change your password (Except '9999') ",
      Login_Invalid_username:"Invalid account",
      Password_must_be_between_4_and_32_characters:"The password must be between 4 and 32 characters long.",
      Login_Wait3min:"You have attempted to log in too many times.For security reasons, the system currently does not allow you to log in.Please wait for 3 minutes and try again.",
      Login_Seconds_remaining:"Seconds remaining",
      Password_change_successfully:"Password change successfully",
      Password_change_failed:"Password change failed",
      Please_enter:"Please enter ",
      Please_enter_currentPassword:'Please enter your password.',
      Please_enter_newPassword:'Please enter your new password.',
      Please_re_enter_confirmPassword:'Please re-enter your password.',
      File_is_validated:"File is validated, sending to system...",
      Error_File:"Error: Upload processing failed",
      Calibration_data_sent_successfully:"Calibration data sent successfully! File: ",
      Cam_ConnectError_Hint:"Notice: Camera connection error, please check camera status.",
      Username_must_be_between_4_and_32_characters:'The username must be between 4 and 32 characters long.',
      newPassword_confirmPassword_not_same:'The confirmed password does not match the new password.',
      Current_password_is_incorrect:'The current password you entered is incorrect.',
      New_password_must_be_different_from_current_password:'The confirmed password does not match the new password.',
      Wrong_password:"Wrong password,",
      Attempt_left:"attempt left",
      DeviceAPICertificate: "Upload Certificate*",
      DeviceAPIPrivateKey: "Upload Private Key*",
      DeviceAPITokens: "Access key(API Tokens)*",
      Browse_or_drop_a_file_here:"Browse or drop a file here",
      File_selected:"File selected",
      Please_select_a_valid_certificate:"Please select a valid certificate file (.crt)",
      Please_select_a_valid_private_key:"Please select a valid private key file (.key)",
      All_Zone_map: "Mapping Overview",
      Label_SetEnableDirector: "Enable",
      Label_EnableDirectorTooltip:"When Intelligent Director is enabled, voice tracking will automatically be disabled.",
      Microphone_Zone_change_apply:'Microphone Zone change apply!',
      Enter_microphone_zone_editing_mode:'Enter microphone zone editing mode', 	
      Enter_map_view_mode:'Enter map view mode',
      All_microphone_information_visible:'All microphone information visible!',
      Single_microphone_visible:'Single microphone visible.',
      Show_Microphone_Zone:'Show Microphone Zone',
      Hide_Microphone_Zone: 'Hide Microphone Zone',
    },
    tw: {
      Label_Settings: "設定",
      Span_MenuSettings: "設定",
      Menu_Device: "設備",
      Span_MenuNetwork: "網路",
      Label_Network:"網路",
      Menu_Security: "安全性",
      Menu_Maintenance: "維護",
      Label_Language: "語言",
      Apply: "確認",
      Cancel: "取消",
      OK:"確定",
      A_tabDevice: "設備",
      A_tabAutoConnection: "自動連線",
      A_tabDante: "Dante",
      A_tabExtensionSetup: "擴充設定",
      BC200_Setup_Mode: "BC-200 校準設定模式",
      A_tabWebUser: "網路使用者",
      A_tabMaintenance: "維護",
      Label_tabOptimization:"最佳化",
      Label_tabBetaFunctions:"測試版 功能",
      Label_tabScheduleReboot: "重啟",
      Label_DebugMode:"偵錯 模式",
      Label_Activate_the_log_collection:"在麥克風頁面啟動日誌收集控制。",
      Label_After_applying_the_settings:"套用設定後，配置頁面上將顯示調試控制項。",
      
      Span_MenuAbout: "關於",
      ActiveData: "啟用資料",
      Add: "新增",
      Address: "地址",
      Administrator: "管理者",
      Advanced: "進階設定",
      Span_MenuStreamAIDirector: "智能導播",
      Label_Intelligence_Director:"智能導播",
      AI_Setting: "智能設定",
      All_Camera:"全部",
      All_Mic_off_Stream: "所有麥克風均關閉直播",
      ALL_XY_Mode: "全 XY 模式",
      Area: "區域",
      Microphone: "麥克風",
      Label_Array_Microphone: "陣列麥克風",
      Array_Microphone: "陣列麥克風",
      Label_Arrary_Microphone_Numbers: "設備數量",
      Array_No: "陣列區號碼",
      Audio_to_USB_output: "音訊轉 USB 輸出",
      Audio_Trigger: "音訊觸發",
      Label_Nimble_ear_audio_trigger_title:"音訊觸發 (dB)",
      Audio_Trigger_Level: "音訊觸發門檻 > dB",
      Audio_Trigger_Level_dB: "音訊觸發門檻 (dB)",
      Auto_Check: "自動檢查",
      Auto_Connection: "自動連線",
      Label_Auto_Run: "自動執行",
      Run:"執行",
      Save: "儲存",
      Auto_Save: "自動儲存",
      AutoSave_Interval: "自動保存間隔",
      Label_layoutTypeSelect_Auto: "自動",
      Label_layoutTypeSelect_Custom: "自訂義",
      Label_Auxiliary_Camera: "輔助攝影機",
      Label_BC200_Label_Cameraname: "輔助攝影機",
      Auzimuth_Angle: "方位角",
      Awaiting: "等待中",
      Pending: "等待中",
      Back: "返回",
      Home: "原點",
      Back_to_Home_Time: "返回原點時間 (秒)",
      Back_to_Home_Camera:"返回原點攝影機",
      Back_to_Home_Position:"返回原點位置",
      Call_AB_Preset_Cruise: "呼叫A B 預設位巡航",
      Call_CAM: "呼叫攝影機",
      CAM: "攝影機",
      Camera: "攝影機",
      Camera_Calibration: "攝影機 校準",
      Calibration: "校準",
      Camera_Control_Status: "攝影機控制和狀態",
      Label_PTZ_Control:"PTZ",
      Label_Cameralist: "攝影機列表",
      Span_MenuStreamCameraList: "攝影機列表",
      Center_Stage: "預設位置中",
      BtnCheckUpdated:"檢查",
      Check:"檢查",
      Clear_All: "全部清除",
      Clear_Log: "清除日誌",
      Label_Clear_Log: "清除日誌",
      Configure_File: "設定檔",
      Confirm_Password: "密碼確認",
      Label_CameraList_Connect: "連接",
      Label_BC200_Label_Connect: "連接",
      Connect: "連接",
      Connect_Error: "連線錯誤",
      Connected: "已連線",
      Ready: "準備就緒",
      Unconnect:  "已斷線",
      Disconnected: "已斷線",
      Disconnecting: "斷開連接中",
      Connecting: "連線中",
      Continue_Tracking: "繼續追蹤",
      Conversation: "對話模式",
      Conversation_Mode: "對話模式",
      Crop: "裁切",
      Span_LayoutCrossCrop: "裁切",
      Cross: "四分割",
      Label_layoutTypeSelect_Cross: "四分割",
      Cruise: "巡航模式",
      Cruise_Mode: "巡航模式",
      Current_Password: "當前密碼",
      Customize: "自訂義模式",
      Customize_X: "自訂義模式 X",
      Customize_1: "自訂義模式 1",
      Customize_2: "自訂義模式 2",
      Decvice_IP: "設備IP位址",
      Sec: "秒",
      Label_Sec: "秒",
      deg_sec: "度/秒",
      Delay: "延遲",
      delay_X_milliseconds: "延遲 X 毫秒",
      delay_X_minutes: "延遲 X 分鐘",
      delay_X_seconds: "延遲 X 秒",
      deleteButton: "刪除",
      Label_Nimble_detetcive_time_title: "偵測時間 (秒)",
      Label_Device_Camera_Mapping: "設備和攝影機對應",
      Camera_Mapping: "攝影機對應",
      Label_Device_Name: "設備名稱",
      Label_System_Startup_Waiting_Time: "系統啟動等待時間",
      Label_System_Startup_Waiting_Time_Hint: " 分鐘 (3~99)", 
      Label_Visca_WaitingAck_Time: "Visca等待時間",
      Label_Visca_WaitingAck_Time_Hint: " 秒 (0~10)",
      Label_Nimble_Eye_Triger_Stable_Range:"BC-200 相互觸發偵測範圍",
      Label_Nimble_Eye_Triger_Stable_Range_Hint: "米 (0.1 ~ 5 米，0 為關閉)",
      Label_Nimble_Eye_Dection_Range:"BC-200 顯示器偵測範圍",
      Label_Nimble_Eye_Dection_Range_Hint: "米 (0.1 ~ 5 , 0 為關閉)",
      Label_Nimble_Eye_Show_Box: "BC-200 顯示人體偵測框",
      Label_CameraList_Source_Name: "訊源名稱",
      Device_Numbers: "設備數量",
      Span_MenuDevices: "設備",
      Devices: "設備",
      Device: "設備",
      Label_Microphone_DeviceType: "設備",
      Device_IP:"設備IP位址",
      Label_Microphone_DeviceIP:"設備IP位址",
      Director_Mode_Loading: "導播模式及麥克風設定正在載入...",
      Label_Microphone_Setting:"麥克風設定",
      Disk_Check: "磁碟檢查",
      Label_DNS: "網域",
      do: "做",
      Edit: "編輯",
      Label_Intelligence_Director_Edit:"編輯",
      Enable: "啟用",
      Enable_Zone: "啟用區域模式",
      Error_Notification: "錯誤通知",
      Event_Log: "事件日誌",
      Exclusion_Mode: "排除模式",
      execution: "執行",
      Execution_Log: "執行日誌",
      Label_Intelligence_Director_Execution_Log:"執行日誌",
      Export: "匯出",
      Export_Log: "匯出日誌",
      Export_Script: "匯出腳本",
      Extension: "擴充",
      Extension_Setup: "擴充設定",
      Setup: "設定",
      Label_File_Saved_Time: "文件存檔時間",
      Firmware_OTA: "OTA韌體",
      Firmware_Update: "韌體更新",
      Firmware_Version: "韌體版本",
      Label_Gateway: "閘道",
      ID: "ID",
      Import: "匯入",
      Import_Script: "匯入腳本",
      Information: "資訊",
      Interval: "間隔",
      IP: "IP位址",
      Label_BC200_Label_IP: "IP位址",
      IP_USB: "IP/USB",
      Label_IPAddress: "IP位址",
      IPv4: "IPv4",
      Layout: "版型",
      Label_LayoutType2:"版型",
      Layout_Type: "版型類型",
      Label_LayoutType:"版型類型",
      Leave: "離開",
      Load: "載入",
      mode: "模式",
      Profile:"預設檔",
      Save_Success:"保存成功!!",
      Span_Load_Profile: "載入預設檔",
      Saving_Profile:"保存 預設檔",
      data:"數據",
      Label_Profile_Index:"預設檔 ID :",
      Label_Location: "位置",
      Label_Account: "登入角色 :",
      Loop_Script: "循環腳本",
      Label_MacAddress: "MAC位址",
      Label_About_MACAddress:"MAC位址 :",
      Label_Manual_IP: "手動IP位址",
      Label_Nimble_ManualIPText: "手動IP位址",
      Label_Manufacturer: "製造商 :",
      Mapping_Qty: "對應數量",
      Label_Max_Microphone_Qty: "最大麥克風數量",
      Method: "方法",
      Label_Method:"方法",
      Mic_Zone: "麥克風檢測區",
      Label_BC200_Label_Assign: "麥克風指定",
      Assign: "指派",
      Label_BC200_Camera_Calibration: "攝影機 校準",
      Span_BC200_Camera_Calibration: "攝影機 校準",
      Span_Microphone_BC200_Camera_Calibration: "全域視圖映射",
      Span_Microphone_BC200_Camera_Calibration_Upload:"校準檔案上傳",
      Span_MenuStreamMicrophone: "麥克風",
      Microphone_Setting: "麥克風設定",
      Min: "最小",
      Minute: "分鐘",
      m:"米",
      Zone_Mode: "檢測區模式",
      Mic_Zone_Information: "麥克風檢測區資訊",
      Label_Model_Name: "型號名稱 :",
      Label_Netmask: "網路遮罩",
      New_Password: "新密碼",
      Notice_Camera: "注意：攝影機連線異常，請檢查攝影機狀態。",
      Label_File_Saved_No: "號碼",
      Operation: "操作",
      Label_CameraList_Operation: "操作",
      Label_Nimble_ptz_camera_trigger_title: "PTZ 攝影機 觸發",
      Password: "密碼",
      PBP: "並列畫面",
      Label_layoutTypeSelect_PBP: "並列畫面",
      Port: "埠",
      Pos: "位置",
      Position_X: "位置 X",
      Label_CameraPos1:"位置 1",
      Label_CameraPos2:"位置 2",
      Label_CameraPos3:"位置 3",
      Label_CameraPos4:"位置 4",
      Presenter: "演講者模式",
      Preset: "預設位",
      Preset_X_end: "預設位 X 點結束",
      Preset_X_start: "預設位 X 點開始",
      end: "點結束",
      start: "點開始",
      Preset_No: "預設位號碼",
      Preset_Speed: "預設位速度",
      Preset_Speed_X: "預設速度 X",
      Primary_Camera: "主要攝影機",
      Span_MenuProfiles: "預設檔",
      Label_Profile: "預設檔",
      Label_MirrorProfile: "預設檔 :",
      Label_Profiles_Title: "預設檔",
      Label_Profile_List: "預設檔清單",
      Label_Profile_Name: "設定檔名稱 :",
      Profile_Setting: "預設檔設定",
      Profiles: "預設檔",
      range: "範圍",
      Reboot: "重新開機",
      Reference_Audio: "參考音訊",
      Label_Reference_AudioInput: "參考音訊輸入",
      Reference_Video: "參考影像",
      Repeat_Count: "重複次數",
      Reschedule_in_1: "在",
      Reschedule_in_2: "秒內 重新執行",
      Reschedule_in_X_seconds: "在 X 秒內 重新執行",
      Reschedule_in: "重新執行在",
      Reset: "重置",
      Resolution: "解析度",
      Label_Resolution:"解析度",
      Run: "執行",
      Label_AIDirector_Run: "執行",
      s: "秒",
      Span_Store: "儲存",
      Store: "儲存",
      Span_Save_As_New_Profile: "另存為新設定檔",
      Script_End: "腳本結束",
      Script_Start: "腳本啟動（優先權：",
      Start: "啟動",
      Script_Stop: "腳本停止",
      Seamless_Switching: "無縫切換",
      Seamless_Switch: "無縫切換",
      No_Switch: "關閉",
      Label_SeamlessSwitching: "無縫切換",
      Secondary_Camera: "備用攝影機",
      Auxiliary_Camera:"輔助攝影機",
      Select_Camera_Amout: "選擇攝影機數量",
      Select_Microphone_Channel: "選擇麥克風通道",
      Select_Video_Layout: "選擇影像版型",
      Select_Video_Layout_Mode: "選擇影像版型模式",
      Send_HEX_Commands: "發送十六進位命令",
      Label_SerialNumber: "序號 :",
      Set: "設定",
      Set_CAM: "設定攝影機",
      CAM: "攝影機",
      Setting_Error: "設定錯誤",
      Settings: "設定",
      Software_Update: "軟體更新",
      Sound_Device: "聲音設備",
      Source_Name: "訊源名稱",
      Source_Position: "來源位置",
      Label_SourcePosition: "來源位置",
      Start_Video_Output: "開始影像輸出",
      Stop_Video_Output:"停止影像輸出",
      Static_IP: "靜態IP位址",
      Label_Static_IP: "靜態IP位址",
      Label_BC200_Label_Status:"狀態",
      Label_CameraList_Status: "狀態",
      Stop: "停止",
      Supported_Devices_Settings: "設備和設置",
      Span_MenuSystem: "系統",
      System_Factory: "恢復出廠設定",
      System_Startup_Waiting_Time: "系統啟動等待時間",
      BtnOfflineUpdate: "升級",
      User_Name: "使用者名稱",
      Version: "版本",
      Label_Video_Channel_Qty: "影像頻道數量",
      Video_Output: "影像輸出",
      Video_Output_Layout: "影像輸出版型",
      Label_VideoOutputMode: "影像輸出方式",
      Span_MenuVideoOutputSetting: "影像輸出設定",
      Label_VideoOutputSetting:"影像輸出設定",
      Video_Source_Position: "影像來源位置",
      By_Cam:"使用 攝影機",
      Video_Switching_Mode: "影像切換模式",
      Label_Vision_Zone_Detection_title: "視野區域偵測",
      Voice_range_Height: "聲音環境高度",
      Voice_range_Width: "聲音環境寬度",
      Voice_Source_Detect: "聲音來源偵測",
      Label_SetVoiceTracking: "聲音追蹤",
      Voice_Tracking_Area_range: "聲音追蹤區域範圍",
      Label_Nimble_ear_volume_value_title: "音量值",
      Web_User: "網路使用者",
      Zone: "區",
      Zone_No: "區域號碼",
      Zone_Setting: "區域設置",
      Zone_Full_Map: "區域地圖概覽",
      Zone_Map: "區域地圖",
      Label_SoundDevice: "聲音設備",
      Label_Camera: "攝影機",
      Label_VideoOutput: "影像輸出",
      Label_Interval: "間隔",
      Label_user: "使用者名稱",
      Label_pass1: "當前密碼",
      Label_pass2: "新密碼",
      Label_pass3: "確認密碼",
      Label_DanteEnable: "啟用",
      Label_SetEnableDirector: "啟用",
      Label_DanteUacEnable: "音訊轉 USB 輸出",
      Label_ConfigureFile: "設定檔",
      Label_Firmware_Version: "韌體版本 :",
      Label_CurFirmwareVer: "韌體版本 :",
      Label_OtaAutoCheck: "自動檢查",
      Label_OfflineFirmware: "韌體更新",
      Label_ExportLog: "事件日誌",
      Label_Reboot: "重新開機",
      Label_SystemFactory: "恢復出廠設定",
      Span_Import: "匯入",
      Span_Export: "匯出",
      Label_Export: "匯出",
      Span_Reset: "重置",
      Span_Apply: "確認",
      Zoom:"變焦",
      Mirror_Flip:"鏡像 / 翻轉",
      Mirror_add_Flip:"鏡像 + 翻轉",
      Mirror:"鏡像",
      Flip:"翻轉",
      OFF:"關閉",
      Off:"關閉",
      AF_MF:"對焦模式",
      Label_AFMF:"對焦模式",
      Focus:"對焦",
      Label_FocusPlus:"Focus+",
      Label_FocusMinus:"Focus-",
      Label_DeviceAPIKey:"API存取金鑰",
      Label_VoiceTrackingTooltip:"在此模式下，無法切換或變更攝影機來源及預設設定。",
      Director_Mode_Profile_is_loading:"導播模式及預設檔正在載入",
      Director_Mode_Microphone_Setting_is_loading:"導播模式及麥克風設定正在載入",
      Configuration_initialization_in_progress:"配置初始化中 ...",
      Label_powerOffMsg:"系統正在處理中。請稍後再試。",
      web_page_connection_has_failed:"網頁連線失敗，請重新載入頁面…",
      web_page_controlByGUI:"裝置目前正在透過 HDMI 介面操作中。請稍後再試，待本地控制結束後即可使用網頁設定。",
      The_power_during_the_firmware_update:"請不要在韌體更新過程中切斷電源",
      Please_wait:"請稍候 …",
      Label_Intelligence_Director_Result:"結果 ：",
      Label_Intelligence_Director_Script_Result:"結果 ：",
      Label_Execution_Script:"執行腳本",
      Label_Script_Leave :"離開",
      Label_Import_Script :"導入腳本",
      Label_Script_Save :"儲存",
      Label_Export_Script :"匯出腳本",
      Label_Script_Save_File_Success :"儲存檔案成功!",
      Label_Script_Stop :"停止",
      Label_Script_Run :"運行",
      Label_Script_Execution_Log :"執行日誌",
      Label_Script_Clear_Log :"清除日誌",
      Label_Script_Export_Log :"匯出日誌",
      Label_PTZCameraView_Title:"PTZ 攝影機",
      Label_BC200CameraView_Title:"輔助攝影機",
      Select_Camera:"選擇攝影機",
      Select_Camera_Preset:"選擇攝影機預設位置",
      Select_CameraZoomRatio:"選擇攝影機縮放倍率",
      Pan_Tilt_Reset:"平移 / 傾斜 重置",
      Coordinate_Calbriatoin_Center: "坐標校準中心（平移/傾斜）：",
      Coordinate_Calbriatoin_Center_Zoom: "坐标校准中心（平移/倾斜/縮放）：",
      null:"關閉",
      No_cameras_available:"關閉",//"沒有可用的攝影機",
      The_file_is_not_valid:"檔案格式错误",
      OffLine_OTA_Hint:   "系統在完成更新程序後會自動關機。 <br>"
                        + "請在關機完成後開啟電源或重新插拔電源！ <br>"
                        + "您可以透過 HDMI 輸出來檢查更新狀態。<br>",
      Microphone_Assign_List:"麥克風指定清單",
      Number: "編號",
      Angle_Location_Direction:"角度/位置/方向",
      Span_Add:"新增",
      Span_Set:"設定",
      Span_Setup:"設定",
      Span_Upload:"上傳",
      Check_error_please_check_network_status:"檢查錯誤，請確認網路狀態。",
      System_Process_Failed: "系統處理失敗。請確認網路狀態和設定。",
      Wait_For_Version_Check: "等待檢查版本",
      Reset_To_Default_And_Reboot: "您確定要將系統重置為預設值,並自動重新啟動嗎？",
      Reset_To_Default_And_Auto_Reboot: "您確定要將系統重置為預設值,並自動重新啟動嗎？",
      PTZ_Control_Available_When_Connected: "只有在攝影機連接時，才能使用PTZ控制。",
      Intelligence_Director_Mode_Active: "智能導播模式目前已啟用。控制和設置不可用。",
      Shut_Down_System: "您確定要關閉系統嗎？",
      Wait_For_Reboot: "請等待重新啟動。",
      Wait_For_Dante_Settings: "請等待設置 Dante。",
      System_Temperature_Overheating: "注意：系統溫度過熱！",
      Check_Installation_Environment: "請檢查安裝環境，並參閱用戶手冊中的故障排除指南以解決問題。",
      Contact_Lumens_Support: "或通過掃描QR碼聯繫Lumens支持。",
      Description_Of_Update: "更新說明：",
      Waiting_For_System_Files_Update: "等待系統文件更新…",
      File_loaded_successfully: "檔案載入成功！",
      File_loaded_XML_Failed:"無法載入 XML 檔！",
      Version_Up_To_Date: "您的當前版本是最新的。",
      System_Initializing: "系統正在初始化…",
      Update_Available: "有可用的更新",
      Newer_CamConnect_Version: "有新版本的 CamConnect Processor 可用。",
      Update_Now: "立即更新",
      Span_Update_Now: "立即更新",
      Later: "稍後更新",
      Span_Later: "稍後更新",
      Release_Notes: "發行說明",
      Span_Release_Notes: "發行說明",
      Done: "完成",
      Auto_Reboot_After_Update: "更新完成後，系統將自動重新啟動。",
      Updating: "正在更新：",
      Call_Camera:"呼叫攝影機",
      Call:"呼叫",
      Back_To_Home:"回到原點",
      Back_to_Home:"回到原點",
      Conversation_Mode_for_1_by_2_Layout:"1 x 2 版型的對話模式",
      milliseconds:"毫秒",
      s: "秒",
      seconds: "秒",
      min:"分鐘",
      minutes: "分鐘",
      Microphone_Select:"麥克風選擇",
      Call_camera_preset_with_range:"呼叫帶範圍的攝影機預置位",
      Send_HEX_Commands:"發送十六進位命令",
      Send_VISCA_Command:"发送 VISCA 命令",
      Script_next_execution:"腳本下次執行",
      Time_to_Mute: "靜音時間",
      Time_to_Trigger: "觸發時間",
      Time_To_Trigger_Preset: "觸發呼叫預設點的時間",
      Trigger_count: "觸發次數",
      Status: "狀態",
      Cruise_Mode_for_1_by_3_Layout:"1x3 佈局的巡航模式",
      Select_channel:"選擇頻道",
      Select_Camera_Amount:"選擇攝影機數量",
      Cruise_Mode:"巡航模式",
      X_Y:"X 點 -> Y 點",
      X_start_X_end_Y_start_Y_end:"X 起點 -> X 終點 -> Y 起點 -> Y 終點",
      Please_wait_for_the_streaming_screen:"請稍候，正在載入串流畫面…",
      Trigger_Time: "觸發時間（秒)",
      Camera_Selection:"攝影機選擇",
      Position_Type:"位置類型",
      Camera_and_BC200_Calibration:"選擇與 BC-200 一起安裝的攝影機。",
      Are_you_sure_you_want_to_reboot_the_system :"您確定要重新啟動系統嗎?",
      PTZ_Control_only_available_while_camera_is_connected:"只有在攝影機連接時，才能使用PTZ控制。",
      Config_Import_Success: "檔案配置匯入成功。<br>請等待系統重啟，這將需要約 3 分鐘。<br>系統重啟後，請刷新瀏覽器並重新登入。",
      Dante_Activation_Data_Backup: "Dante 激活數據備份",
      Dante_Activation_Message: "保存和導出 Dante 激活數據的過程對於確保設備的順利運行至關重要。<br>定期備份有助於防止在設備更換或突發問題的情況下發生身份驗證失敗。<br>為了提高可靠性和數據安全性，建議手動備份。",
      Dante_Activation_Instructions: "（前往系統選項頁 > 設定 > Dante，然後在激活數據下點擊“導出”）",
      Do_Not_Notify_Next_Time: "了解，請下次不要再通知我。",
      BC200ConnectError:"此BC-200不在連線清單內<br>請重新檢查連線是否正常<br>並確認設備不是「未知」設備。",
      Please_wait_for_the_canvas_file_to_loading:"請等待畫布檔案加載...",
      Retrying_to_get_canvas_file_A:"第",
      Retrying_to_get_canvas_file_B:"次重試取得畫布檔案",
      Retrying_to_get_canvas_file_C:"(最多",
      Retrying_to_get_canvas_file_D:"次)",
      Retrying_to_get_canvas_file_End:"無法檢索畫布文件，請關閉視窗並重試",
      Camera_Get_BC200_No:"目前已取得攝影機串流，但未取得BC-200串流。重新嘗試獲取 BC-200 流。",
      Camera_No_BC200_Get:"已成功取得 BC-200 串流，但尚未取得攝影機串流。系統將重新嘗試連線。",
      Camera_No_BC200_NO:"目前未取得攝影機串流或 BC-200 串流。重試獲取所有串流。",
      Please_wait_for_the_camera_calibration_to_save: "請等待攝影機校準資料保存。",
      Camera_calibration_pan_tilt_is_not_save:"尚未儲存此攝影機的校正資料。",
      Wait_Get_Sound_data: "請等待麥克風頁面資料同步。",
      Wait_get_extension_setup_data: "請等待讀取擴充設定資料。",
      Label_powerStandByModeMsg:"系統處於待機模式。請按下電源按鈕重新啟動系統。",
      Processing_Request:"正在處理請求。請稍候...",
      BLS_Parameters_Label: "參數",
      BLS_NoiseLevelThreshold_Label: "噪音閾值",
      BLS_NoiseLevelThreshold_Tooltip: "設置噪音閾值乘數。範圍：100.0 ~ 300.0（100.0 適合安靜環境，300.0 適合嘈雜環境）。",
      BLS_XAxisDistanceDiff_Label: "X軸位置變化閾值",
      BLS_XAxisDistanceDiff_Tooltip: "X軸位置變化的閾值。範圍：10 ~ 50（10 檢測小移動，50 忽略小範圍移動）。",
      BLS_YAxisDistanceDiff_Label: "Y軸位置變化閾值",
      BLS_YAxisDistanceDiff_Tooltip: "Y軸位置變化的閾值。範圍：10 ~ 50（10 檢測小移動，50 忽略小範圍移動）。",
      BLS_SoundIntensityDiff_Label: "聲音強度變化閾值",
      BLS_SoundIntensityDiff_Tooltip: "聲音強度變化的閾值。範圍：1 ~ 5（1 檢測小幅變化，5 忽略小波動）。",
      BLS_MicSelectionTime_Label: "麥克風選擇時間",
      BLS_MicSelectionTime_Tooltip: "麥克風選擇的最小時間間隔。範圍：20 ~ 100（20 快速響應，100 高穩定性）。",
      BLS_HistorySize_Label: "歷史記錄大小",
      BLS_HistorySize_Tooltip: "分數歷史記錄窗口大小。範圍：1 ~ 5（1 無平滑，5 強平滑）。",
      BLS_MicSwitchThreshold_Label: "麥克風切換閾值",
      BLS_MicSwitchThreshold_Tooltip: "麥克風切換的閾值。範圍：0.9 ~ 1.3（0.9 易切換，1.3 高穩定性）。",
      BLS_DistanceWeight_Label: "距離權重",
      BLS_DistanceWeight_Tooltip: "距離在分數計算中的權重。範圍：0.3 ~ 0.7（0.5 平衡，0.7 強調距離）。",
      BLS_SoundIntensityWeight_Label: "聲音強度權重",
      BLS_SoundIntensityWeight_Tooltip: "聲音強度在分數計算中的權重。範圍：0.3–0.7（0.5 平衡，0.7 強調分貝）。",
      BLS_NumberOfInputs_Label: "輸入特徵數量",
      BLS_NumberOfInputs_Tooltip: "BLS模型輸入特徵數量。範圍：9– ~ 12（9 簡化模型，12 包括phiAngle）。",
      BLS_FeatureNodes_Label: "特徵節點數量",
      BLS_FeatureNodes_Tooltip: "BLS模型特徵節點數量。範圍：6 ~ 16（6 低成本，16 高精度）。",
      BLS_EnhanceNodes_Label: "增強節點數量",
      BLS_EnhanceNodes_Tooltip: "BLS模型增強節點數量。範圍：6 ~ 16（6 低成本，16 高精度）。",
      BLS_MaxTracksSize_Label: "最大跟踪數據數量",
      BLS_MaxTracksSize_Tooltip: "最大跟踪數據數量。範圍：5 ~ 20（5 適合動態場景，20 適合靜態場景）。",
      BLS_MicDataSaveWindowSize_Label: "麥克風數據窗口大小",
      BLS_MicDataSaveWindowSize_Tooltip: "歷史分貝和位置數據的窗口大小。範圍：3 ~ 10（3 適合動態場景，10 適合靜態場景）。",
      Debug_Mode_Data_save:"等待調試模式資料保存。",
      BLS_Select_Environment: "選擇環境",
      BLS_Select_Environment_Default: "預設",
      BLS_Select_Environment_QuietOffice: "安靜辦公室",
      BLS_Select_Environment_NoisyCafe: "嘈雜咖啡廳",
      BLS_Select_Environment_ConferenceRoom: "會議室",
      BLS_Select_Environment_LargeLectureHall: "大型演講廳",
      BLS_Select_Environment_OutdoorEvent: "戶外活動",
      BLS_Select_Environment_RecordingStudio: "錄音室",
      BLS_Select_Environment_TelemedicineClinic: "遠程醫療診所",
      BLS_Environment_Default_Tooltip: "特性：高噪音閾值 (200.0)，短距離差異 (20)，高距離權重 (0.8)，適應一般會議室或動態環境。調整原因：提供平衡設置，適合多數環境，強調空間定位以快速適應不同場景。",
      BLS_Environment_QuietOffice_Tooltip: "特性：低噪音閾值 (120.0)，中等距離差異 (25)，較高距離權重 (0.6)，快速麥克風選擇 (40ms)。調整原因：優化安靜環境，降低噪音敏感度以聚焦清晰語音，快速切換提升單人發言效率。",
      BLS_Environment_NoisyCafe_Tooltip: "特性：高噪音閾值 (200.0)，大距離差異 (40)，高聲音強度權重 (0.6)，較長歷史記錄 (4)。調整原因：適應嘈雜環境，高閾值過濾背景噪音，強調聲音強度以區分主要語音，增加穩定性。",
      BLS_Environment_ConferenceRoom_Tooltip: "特性：中等噪音閾值 (160.0)，中等距離差異 (35)，平衡權重 (0.5/0.5)，標準歷史記錄 (3)。調整原因：適合典型會議室，平衡噪音和定位需求，確保穩定切換和語音清晰度。",
      BLS_Environment_LargeLectureHall_Tooltip: "特性：較高噪音閾值 (180.0)，大距離差異 (45)，較多特徵節點 (14)，大跟踪數據 (18)。調整原因：適應大型空間，允許更大移動範圍，高精度模型支持多人和遠距離語音捕捉。",
      BLS_Environment_OutdoorEvent_Tooltip: "特性：極高噪音閾值 (220.0)，最大距離差異 (50)，高聲音強度權重 (0.7)，最多跟踪數據 (20)。調整原因：應對戶外噪音，忽略小範圍移動，強調聲音強度以捕捉主要語音，適合動態場景。",
      BLS_Environment_RecordingStudio_Tooltip: "特性：極低噪音閾值 (100.0)，小距離差異 (20)，高距離權重 (0.7)，最短歷史記錄 (1)。調整原因：優化高品質錄音，極高靈敏度捕捉細微聲音，快速響應和精確定位確保錄音純淨。",
      BLS_Environment_TelemedicineClinic_Tooltip: "特性：低噪音閾值 (110.0)，小距離差異 (22)，較高距離權重 (0.65)，少量跟踪數據 (6)。調整原因：專為單人對話設計，低閾值確保清晰語音，精確定位和快速切換支持醫療對話。",
      Span_Import:"導入",
      Span_Export:"導出",
      Label_Debug_Mode:"偵錯模式",
      Label_Parameter_Mode:"參數調整模式",
      Label_Execution_Header:"執行訊息",
      Span_Clear_Message:"清除偵錯訊息",
      Span_Output_Message:"輸出偵錯訊息",
      Enter_file_name_to_save:"請輸入您想要儲存的檔案名稱。",
      Conversation_Rules:"對話模式規則",
      Position_Index: "位置",
      Enter_Switch_Time: "進入時間",
      Exit_Switch_Time: "退出時間",
      Enter_Switch_Count: "觸發次數",
      Exit_Switch_Count: "靜音次數",
      Control_Panel:"控制面板",
      Label_DisableSchedule: "停用",
      Label_DailyRebootHint: "(Available when CamConnect is connected to a network and synchronized with an NTP server.)",
      Label_RebootTiming:"定時重啟",
      Label_RebootTimingHint: "(Available when CamConnect is used without a network connection. Uses the system startup time for the reboot schedule.)",
      Label_PipMode: "PIP",
      Remember_Me:"記住我",
      User_Name:"使用者名稱",
      LogIn:"登入",
      Please_enter_your_username:"請輸入您的使用者名稱。",
      Please_enter_your_password:"請輸入您的密碼",
      Username_saved:"帳號已保存",
      Viewer_LogIn:"檢視者 登入",
      Username_admin:"管理者",
      Username_viewer:"檢視者",
      Login_Failed:"登入失敗",
      Please_change_your_password:"請更改您的密碼（'9999' 除外）",
      Login_Invalid_username:"帳號無效",
      Password_must_be_between_4_and_32_characters:"密碼長度必須為 4 至 32 個字元。",
      Login_Wait3min:"您嘗試登入的次數過多。出於安全考慮，系統目前不允許您登入。請等待 3 分鐘，然後再試一次。",
      Login_Seconds_remaining:"剩餘時間",
      Password_change_successfully:"密碼已成功更改。",
      Password_change_failed:"密碼更改失敗。",
      Please_enter:"請輸入",
      Please_re_enter_confirmPassword:'請再次輸入您的密碼。',
      Please_enter_currentPassword:'請輸入您的密碼。',
      Please_enter_newPassword:'請輸入您的新密碼。',
      File_is_validated:"文件已驗證，正在發送至系統...",
      Error_File:"錯誤：上傳處理失敗",
      Calibration_data_sent_successfully:"校準資料發送成功！檔案：",
      Cam_ConnectError_Hint:"注意：攝影機連線異常，請檢查攝影機狀態。",
      Username_must_be_between_4_and_32_characters:'帳號必須為 4 到 32 個字元。',
      newPassword_confirmPassword_not_same:'您輸入的確認密碼與新密碼不相符。',
      Current_password_is_incorrect:'您輸入的當前密碼不正確。',
      New_password_must_be_different_from_current_password:'新密碼必須與當前密碼不同',
      Wrong_password:"密碼錯誤，還剩",
      Attempt_left:"次嘗試機會",
      DeviceAPICertificate: "上傳憑證檔*",
      DeviceAPIPrivateKey: "上傳私鑰檔*",
      DeviceAPITokens: "存取金鑰(API 權杖)*",
      Browse_or_drop_a_file_here:"瀏覽或將檔案拖放到此處",
      File_selected:"選定文件",
      Please_select_a_valid_certificate:"請選擇有效的憑證檔案 (.crt)",
      Please_select_a_valid_private_key:"請選擇一個有效的私鑰檔案（.key）",
      All_Zone_map: "區域映射概述",
      Label_EnableDirectorTooltip:"當啟用智能導播時，語音追蹤將自動停用。",
      Microphone_Zone_change_apply:'麥克風區域變更生效！',
      Enter_microphone_zone_editing_mode:'進入麥克風區域編輯模式',
      Enter_map_view_mode:'進入地圖視圖模式',   
      All_microphone_information_visible:'所有麥克風資訊均可見',
      Single_microphone_visible:'單一麥克風可見',
      Show_Microphone_Zone:'顯示麥克風區域',
      Hide_Microphone_Zone:'隱藏麥克風區域',
    },
    zh: {
      Label_Settings: "设置",
      Span_MenuSettings: "设置",
      Menu_Device: "设备",
      Span_MenuNetwork: "网络",
      Label_Network:"网络",
      Menu_Security: "安全性",
      Menu_Maintenance: "维护",
      Label_Language: "语言",
      Apply: "确认",
      Cancel: "取消",
      OK:"确定",
      A_tabDevice: "设备",
      A_tabAutoConnection: "自动连线",
      A_tabDante: "Dante",
      A_tabExtensionSetup: "扩充设定",
      BC200_Setup_Mode: "BC-200 校准设定模式",
      A_tabWebUser: "网路用户",
      A_tabMaintenance: "维护",
      Label_tabOptimization:"优化",
      Label_tabBetaFunctions:"测试版 功能",
      Label_tabScheduleReboot: "重启",
      Label_DebugMode:"调试 模式",
      Label_Activate_the_log_collection:"在麦克风页面激活日志收集控制。",
      Label_After_applying_the_settings:"应用设置后，配置页面上将显示调试控制项。",
      
      Span_MenuAbout: "关于",
      ActiveData: "启用资料",
      Add: "新增",
      Address: "地址",
      Span_Administrator: "管理者",
      Viewer:"檢視者",
      Advanced: "高级设置",
      Span_MenuStreamAIDirector: "智能导播",
      Label_Intelligence_Director: "智能导播",
      AI_Setting: "智能设定",
      All_Camera: "全部",
      All_Mic_off_Stream: "所有麦克风均关闭直播",
      ALL_XY_Mode: "全 XY 模式",
      Area: "区域",
      Microphone: "麦克风",
      Label_Array_Microphone: "阵列麦克风",
      Array_Microphone: "阵列麦克风",
      Label_Arrary_Microphone_Numbers: "设备数量",
      Array_No: "阵列号码",
      Audio_to_USB_output: "音讯转 USB 输出",
      Audio_Trigger: "音讯触发",
      Label_Nimble_ear_audio_trigger_title: "音讯触发 (dB)",
      Audio_Trigger_Level: "音讯触发门槛 > dB",
      Audio_Trigger_Level_dB: "音讯触发门槛 (dB)",
      Auto_Check: "自动检查",
      Auto_Connection: "自动连线",
      Label_Auto_Run: "自动执行",
      Run:"执行",
      Auto_Save: "自动储存",
      AutoSave_Interval: "自动保存间隔",
      Label_layoutTypeSelect_Auto: "自动",
      Label_layoutTypeSelect_Custom: "自订义",
      Label_Auxiliary_Camera: "辅助摄像机",
      Label_BC200_Label_Cameraname: "辅助摄像机",
      Auzimuth_Angle: "方位角",
      Awaiting: "等待中",
      Pending: "等待中",
      Back: "返回",
      Home: "原点",
      Back_to_Home: "返回原点",
      Back_To_Home: "返回原点",
      Back_to_Home_Time: "返回原点时间(秒)",
      Back_to_Home_Camera:"返回原点摄像机",
      Back_to_Home_Position:"返回原点位置",
      Call_AB_Preset_Cruise: "呼叫A B 预设位巡航",
      Call_CAM: "呼叫摄像机",
      CAM: "摄像机",
      Camera: "摄像机",
      Camera_Calibration: "摄像机 校准",
      Calibration: "校准",
      Camera_Control_Status: "摄像机控制和状态",
      Label_PTZ_Control:"PTZ",
      Label_Cameralist: "摄像机列表",
      Span_MenuStreamCameraList: "摄像机列表",
      Center_Stage: "预设位居中",
      BtnCheckUpdated:"检查",
      Check:"检查",
      Clear_All: "全部清除",
      Clear_Log: "清除日志",
      Label_Clear_Log: "清除日志",
      Configure_File: "设定档",
      Confirm_Password: "密码确认",
      Label_CameraList_Connect: "连接",
      Label_BC200_Label_Connect: "连接",
      Connect:"连接",
      Connect_Error: "连线错误",
      Connected: "已连接",
      Ready: "准备就绪",
      Unconnect:  "已断线",
      Disconnected: "已断线",
      Disconnecting: "断开连接中",
      Connecting: "连接中",
      Continue_Tracking: "继续追踪",
      Conversation: "对话模式",
      Conversation_Mode: "对话模式",
      Crop: "裁切",
      Span_LayoutCrossCrop :"裁切",
      Cross: "十字",
      Label_layoutTypeSelect_Cross :"十字",
      Cruise: "巡航模式",
      Cruise_Mode: "巡航模式",
      Current_Password: "当前密码",
      Customize: "自订义模式",
      Customize_X: "自订义模式 X",
      Customize_1: "自订义模式 1",
      Customize_2: "自订义模式 2",
      Decvice_IP: "设备IP地址",
      Sec:"秒",
      Label_Sec:"秒",
      deg_sec: "度/秒",
      Delay: "延迟",
      delay_X_milliseconds: "延迟 X 毫秒",
      delay_X_minutes: "延迟 X 分钟",
      delay_X_seconds: "延迟 X 秒",
      deleteButton: "删除",
      Label_Nimble_detetcive_time_title: "侦测时间 (秒)",
      Label_Device_Camera_Mapping: "设备和摄像机对应",
      Camera_Mapping: "摄像机对应",
      Label_Device_Name: "设备名称",
      Label_System_Startup_Waiting_Time: "系統啟動等待時間",
      Label_System_Startup_Waiting_Time_Hint: " 分钟 (3~99)", 
      Label_Visca_WaitingAck_Time: "Visca等待時間",
      Label_Visca_WaitingAck_Time_Hint: " 秒 (0~10)", 
      Label_Nimble_Eye_Triger_Stable_Range:"BC-200 相互触发检测范围",
      Label_Nimble_Eye_Triger_Stable_Range_Hint: "米 (0.1 ~ 5 米，0 为关闭)",
      Label_Nimble_Eye_Dection_Range:"BC-200 显示屏检测范围",
      Label_Nimble_Eye_Dection_Range_Hint: "米 (0.1 ~ 5 米，0 为关闭)",
      Label_Nimble_Eye_Show_Box: "BC-200 显示人体检测框",
      Label_CameraList_Source_Name: "讯源名称",
      Device_Numbers: "设备数量",
      Span_MenuDevices:"设备",
      Devices: "设备",
      Director_Mode_Loading: "导播模式及麦克风设定正在载入...",
      Label_Microphone_Setting:"麦克风设定",
      Disk_Check: "磁碟检查",
      Label_DNS: "网域",
      do: "做",
      Edit: "编辑",
      Label_Intelligence_Director_Edit:"编辑",
      Enable: "开启",
      Enable_Zone: "启用区域模式",
      Error_Notification: "错误通知",
      Event_Log: "事件日志",
      Exclusion_Mode: "排除模式",
      execution: "执行",
      Execution_Log: "执行日志",
      Label_Intelligence_Director_Execution_Log:"执行日志",
      BtnExportLog: "导出",
      Export: "导出",
      Export_Log: "导出日志",
      Export_Script: "导出脚本",
      Extension: "扩充",
      Extension_Setup: "扩充设定",
      Setup: "设定",
      Label_File_Saved_Time: "文本存档时间",
      Firmware_OTA: "OTA韧体",
      Firmware_Update: "固件更新",
      Firmware_Version: "固件版本",
      Label_Gateway: "网关",
      ID: "ID",
      Import: "导入",
      Import_Script: "导入脚本",
      Information: "信息",
      Interval: "间隔",
      IP: "IP地址",
      Label_BC200_Label_IP: "IP地址",
      IP_USB: "IP/USB",
      Label_IPAddress: "IP地址",
      IPv4: "IPv4",
      Layout: "版型",
      Label_LayoutType2:"版型",
      Layout_Type: "版型类型",
      Label_LayoutType: "版型类型",
      Leave: "离开",
      Load: "加载",
      mode: "模式",
      Profile:"预设档",
      Save_Success:"保存成功!!",
      Span_Load_Profile: "载入预设档",
      Saving_Profile:"保存 预设档",
      data:"数据",
      Label_Profile_Index:"预设档 ID :",
      Label_Location: "位置",
      Label_Account: "登入角色 :",
      Loop_Script: "循环脚本",
      Label_MacAddress: "MAC地址",
      Label_About_MACAddress:"MAC地址 :",
      Label_Manual_IP: "手动IP地址",
      Label_Nimble_ManualIPText: "手动IP地址",
      Label_Manufacturer: "制造商 :",
      Mapping_Qty: "对应数量",
      Label_Max_Microphone_Qty: "最大麦克风数量",
      Method: "方法",
      Label_Method:"方法",
      Mic_Zone: "麦克风检测区",
      Label_BC200_Label_Assign: "麦克风指定",
      Assign: "指派",
      Label_BC200_Camera_Calibration: "摄像机 校准",
      Span_BC200_Camera_Calibration: "摄像机 校准",
      Span_Microphone_BC200_Camera_Calibration: "全域視圖映射",
      Span_Microphone_BC200_Camera_Calibration_Upload:"校准文件上传",
      Span_MenuStreamMicrophone: "麦克风",
      Microphone_Setting: "麦克风设定",
      Min: "最小",
      Minute: "分钟",
      m:"米",
      Zone_Mode: "检测区模式",
      Mic_Zone_Information: "麦克风检测区资讯",
      Label_Model_Name: "型号名称 :",
      Label_Netmask: "网络屏蔽",
      New_Password: "新密码",
      Notice_Camera: "注意：摄像机连线异常，请检查摄像机状态。",
      Label_File_Saved_No: "编号",
      Operation: "操作",
      Label_CameraList_Operation: "操作",
      Label_Nimble_ptz_camera_trigger_title: "PTZ 摄像机 触发",
      Password: "密码",
      PBP: "并列画面",
      Label_layoutTypeSelect_PBP: "并列画面",
      Port: "端口号",
      Pos: "位置",
      Position_X: "位置 X",
      Label_CameraPos1:"位置 1",
      Label_CameraPos2:"位置 2",
      Label_CameraPos3:"位置 3",
      Label_CameraPos4:"位置 4",
      Presenter: "演讲者模式",
      Preset: "预设位",
      Preset_X_end: "预设位 X 点结束",
      Preset_X_start: "预设位 X 点开始",
      end: "点结束",
      start: "点开始",
      Preset_No: "预设位编号",
      Preset_Speed: "预设位速度",
      Preset_Speed_X: "预设速度 X",
      Primary_Camera: "主摄像机",
      Span_MenuProfiles: "预设档",
      Label_MirrorProfile:"预设档 :",
      Label_Profile: "预设档",
      Label_Profiles_Title: "预设档",
      Label_Profile_List: "预设档清单",
      Label_Profile_Name: "设定档名称 :",
      Profile_Setting: "预设档设定",
      Profiles: "预设档",
      range: "范围",
      Reboot: "重新开机",
      Reference_Audio: "参考音讯",
      Label_Reference_AudioInput: "参考音讯输入",
      Reference_Video: "参考影像",
      Repeat_Count: "重复次数",
      Reschedule_in_1: "在",
      Reschedule_in_2: "秒内 重新执行",
      Reschedule_in_X_seconds: "在 X 秒内 重新执行",
      Reschedule_in: "重新执行在",
      Reset: "重置",
      Resolution: "分辨率",
      Label_Resolution:"分辨率",
      Run: "执行",
      Label_AIDirector_Run: "执行",
      s: "秒",
      Span_Store: "储存",
      Store: "储存",
      Save: "储存",
      Span_Save_As_New_Profile: "另存为新设定档",
      Script_End: "脚本结束",
      Script_Start: "脚本启动（优先权：",
      Start:"启动",
      Script_Stop: "脚本停止",
      Stop: "停止",
      Seamless_Switching: "无缝切换",
      Seamless_Switch: "无缝切换",
      No_Switch: "关闭",
      Label_SeamlessSwitching: "无缝切换",
      Secondary_Camera: "备用摄像机",
      Auxiliary_Camera:"辅助摄像机",
      Select_Camera_Amout: "选择摄像机数量",
      Select_Microphone_Channel: "选择麦克风通道",
      Select_Video_Layout: "选择影像版型",
      Select_Video_Layout_Mode: "选择影像版型模式",
      Send_HEX_Commands: "发送十六进位命令",
      Label_SerialNumber: "序号 :",
      Set: "设置",
      Set_CAM: "设定摄像机",
      CAM: "摄像机",
      Setting_Error: "设定错误",
      Settings: "设置",
      Software_Update: "软体更新",
      Sound_Device: "声音设备",
      Source_Name: "讯源名称",
      Source_Position: "来源位置",
      Label_SourcePosition: "来源位置",
      Start_Video_Output: "开始影像输出",
      Stop_Video_Output:"停止影像输出",
      Static_IP: "静态IP地址",
      Label_Static_IP: "静态IP地址",
      Label_BC200_Label_Status: "状态",
      Label_CameraList_Status: "状态",
      Stop: "停止",
      Supported_Devices_Settings: "设备和设置",
      Device: "设备",
      Label_Microphone_DeviceType:"设备",
      Device_IP: "设备IP地址",
      Label_Microphone_DeviceIP: "设备IP地址",
      Span_MenuSystem: "系统",
      System_Factory: "恢复出厂设定",
      System_Startup_Waiting_Time: "系统启动等待时间",
      BtnOfflineUpdate: "升级",
      User_Name: "用户名称",
      Version: "版本",
      Label_Video_Channel_Qty: "影像频道数量",
      Video_Output: "影像输出",
      Video_Output_Layout: "视讯输出布局",
      Label_VideoOutputMode: "影像输出方式",
      Span_MenuVideoOutputSetting: "影像输出设定",
      Label_VideoOutputSetting:"影像输出设定",
      Video_Source_Position: "影像来源位置",
      By_Cam:"使用 摄像机",
      Video_Switching_Mode: "影像切换模式",
      Label_Vision_Zone_Detection_title: "视野区域侦测",
      Voice_range_Height: "声音环境高度",
      Voice_range_Width: "声音环境宽度",
      Voice_Source_Detect: "声音来源侦测",
      Label_SetVoiceTracking: "声音追踪",
      Voice_Tracking_Area_range: "声音追踪区域范围",
      Label_Nimble_ear_volume_value_title: "音量值",
      Web_User: "网路用户",
      Zone: "区",
      Zone_No: "区域号码",
      Zone_Setting: "区域设置",
      Zone_Full_Map: "区域地图概览",
      Zone_Map: "区域地图",
      Label_SoundDevice: "声音设备",
      Label_Camera: "摄像机",
      Label_VideoOutput: "影像输出",
      Label_Interval: "间隔",
      Label_user: "用户名称",
      Label_pass1: "当前密码",
      Label_pass2: "新密码",
      Label_pass3: "确认密码",
      Label_DanteEnable: "开启",
      Label_SetEnableDirector: "开启",
      Label_DanteUacEnable: "音讯转 USB 输出",
      Label_ConfigureFile: "设定档",
      Label_Firmware_Version: "固件版本 :",
      Label_CurFirmwareVer: "固件版本 :",
      Label_OtaAutoCheck: "自动检查",
      Label_OfflineFirmware: "固件更新",
      Label_ExportLog: "事件日志",
      Label_Reboot: "重新开机",
      Label_SystemFactory: "恢复出厂设定",
      Span_Import: "导入",
      Span_Export: "导出",
      Label_Export: "导出",
      Span_Reset: "重置",
      Span_Apply: "确认",
      Zoom:"变焦",
      Mirror_Flip:"镜像 / 翻转",
      Mirror_add_Flip:"镜像 + 翻转",
      Mirror:"镜像",
      Flip:"翻转",
      OFF:"关闭",
      Off:"关闭",
      AF_MF:"对焦模式",
      Label_AFMF:"对焦模式",
      Focus:"对焦",
      Label_FocusPlus:"Focus+",
      Label_FocusMinus:"Focus-",
      Label_DeviceAPIKey:"API存取金鑰",
      Label_VoiceTrackingTooltip:"在此模式下，无法切换或变更摄影机来源及预设设定。",
      Director_Mode_Profile_is_loading:"导播模式及预设档正在载入",
      Director_Mode_Microphone_Setting_is_loading:"导播模式及麦克风设置正在载入",
      Configuration_initialization_in_progress:"配置初始化中 ...",
      Label_powerOffMsg:"系统正在处理中。请稍后再试",
      web_page_connection_has_failed:"网页连接失败，请重新加载页面…",
      web_page_controlByGUI:"设备目前正在通过 HDMI 接口操作中。请稍后再试，待本地控制结束后即可使用网页设置。",
      The_power_during_the_firmware_update:"请不要在固件更新过程中切断电源",
      Please_wait:"请稍候 …",
      Label_Intelligence_Director_Result:"结果 ：",
      Label_Intelligence_Director_Script_Result:"结果 ：",
      Label_Execution_Script:"执行脚本",
      Label_Script_Leave :"离开",
      Label_Import_Script :"导入脚本",
      Label_Script_Save :"储存",
      Label_Export_Script :"导出脚本",
      Label_Script_Save_File_Success :"储存档案成功!",
      Label_Script_Stop :"停止",
      Stop :"停止",
      Label_Script_Run :"运行",
      Label_Script_Execution_Log :"执行日志",
      Label_Script_Clear_Log :"清除日志",
      Label_Script_Export_Log :"导出日志",
      Label_PTZCameraView_Title:"PTZ 摄像机",
      Label_BC200CameraView_Title:"辅助摄像机",
      Select_Camera:"选择摄像机",
      Select_Camera_Preset:"选择摄像机预设位置",
      Select_CameraZoomRatio:"选择摄像机缩放倍率",
      Pan_Tilt_Reset:"平移 / 倾斜 重置",
      Coordinate_Calbriatoin_Center: "坐标校准中心（平移/倾斜）：",
      Coordinate_Calbriatoin_Center_Zoom: "坐标校准中心（平移/倾斜/缩放）：",
      null:"关闭",
      No_cameras_available:"关闭",//"没有可用的摄像头",
      The_file_is_not_valid:"文件格式错误",
      OffLine_OTA_Hint:   "系统在完成更新过程后会自动关机。 <br>"
                        + "请在关机完成后重新开机或重新插拔电源！ <br>"
                        + "您可以通过 HDMI 输出查看更新状态。<br>",
      Microphone_Assign_List:"麦克风指定列表",
      Number: "编号",
      Angle_Location_Direction:"角度/位置/方向",
      Span_Add:"新增",
      Span_Set:"设置",
      Span_Setup:"设置",
      Span_Upload:"上传",
      Check_error_please_check_network_status:"检查错误，请确认网络状态。",
      System_Process_Failed: "系统处理失败。请确认网络状态和设定。",
      Wait_For_Version_Check: "等待检查版本",
      Reset_To_Default_And_Reboot: "您确定要将系统重置为默认,并自动重新启动吗？",
      Reset_To_Default_And_Auto_Reboot: "您确定要将系统重置为默认,并自动重新启动吗？",
      PTZ_Control_Available_When_Connected: "只有在摄像机连接时，才能使用PTZ控制。",
      Intelligence_Director_Mode_Active: "智能导播模式目前已启用。控制和设置不可用。",
      Shut_Down_System: "您确定要关闭系统吗？",
      Wait_For_Reboot: "请等待重新启动。",
      Wait_For_Dante_Settings: "请等待设置 Dante。",
      System_Temperature_Overheating: "注意：系统温度过热！",
      Check_Installation_Environment: "请检查安装环境，并参阅用户手册中的故障排除指南以解决问题。",
      Contact_Lumens_Support: "或通过扫描QR码联系Lumens支持。",
      Description_Of_Update: "更新说明：",
      Waiting_For_System_Files_Update: "等待系统文件更新…",
      File_loaded_successfully: "档案载入成功！",
      File_loaded_XML_Failed:"无法载入 XML 文件！",
      Version_Up_To_Date: "您的当前版本是最新的。",
      System_Initializing: "系统正在初始化…",
      Update_Available: "有可用的更新",
      Newer_CamConnect_Version: "有新版本的 CamConnect Processor 可用。",
      Update_Now: "立即更新",
      Span_Update_Now: "立即更新",
      Later: "稍后更新",
      Span_Later: "稍后更新",
      Release_Notes: "发行说明",
      Span_Release_Notes: "发行说明",
      Done: "完成",
      Auto_Reboot_After_Update: "更新完成后，系统将自动重新启动。",
      Updating: "正在更新：",
      Call_Camera:"呼叫摄像机",
      Call:"调用",
      Conversation_Mode_for_1_by_2_Layout:"1 x 2 版型的对话模式",
      milliseconds:"毫秒",
      s: "秒",
      seconds: "秒",
      min:"分钟",
      minutes: "分钟",
      Microphone_Select:"麦克风选择",
      Call_camera_preset_with_range:"调用带范围的摄像头预设",
      Send_HEX_Commands:"发送十六进制命令",
      Send_VISCA_Command:"傳送 VISCA 指令",
      Script_next_execution:"脚本下一次执行",
      Time_to_Mute: "静音时间",
      Time_to_Trigger: "触发时间",
      Time_To_Trigger_Preset: "触发呼叫预设点的时间",
      Trigger_count: "触发次数",
      Status: "状态",
      Cruise_Mode_for_1_by_3_Layout:"1x3 布局的巡航模式",
      Select_channel:"选择频道",
      Select_Camera_Amount:"选择摄像机数量",
      Cruise_Mode:"巡航模式",
      X_Y:"X 点 -> Y 点",
      X_start_X_end_Y_start_Y_end:"X 起点 -> X 终点 -> Y 起点 -> Y 终点",
      Please_wait_for_the_streaming_screen:"请稍候，正在加载串流画面……",
      Span_Administrator:"管理者",
      Viewer:"检视者",
      Trigger_Time: "触发时间（秒)",
      Camera_Selection:"摄像机选择",
      Position_Type:"位置类型",
      Camera_and_BC200_Calibration:"选择与 BC-200 一起安装的摄像机。",
      Are_you_sure_you_want_to_reboot_the_system :"您确定要重新启动系统吗?",
      PTZ_Control_only_available_while_camera_is_connected:"只有在摄像机连接时，才能使用PTZ控制。",
      Config_Import_Success: "档案配置汇入成功。<br>请等待系统重启，这将需要约 3 分钟。<br>系统重启后，请刷新浏览器并重新登入。",
      Dante_Activation_Data_Backup: "Dante 激活数据备份",
      Dante_Activation_Message: "保存和导出 Dante 激活数据的过程对于确保设备的顺利运行至关重要。<br>定期备份有助于防止在设备更换或突发问题的情况下发生身份验证失败。<br>为了提高可靠性和数据安全性，建议手动备份。",
      Dante_Activation_Instructions: "（前往系统选项页 > 设定 > Dante，然后在激活数据下点击“导出”）",
      Do_Not_Notify_Next_Time: "了解，请下次不要再通知我。",
      BC200ConnectError:"此BC-200不在连线清单内<br>请重新检查连线是否正常<br>并确认设备不是「未知」设备。",
      Please_wait_for_the_canvas_file_to_loading:"请等待画布文件加载...",
      Retrying_to_get_canvas_file_A:"第",
      Retrying_to_get_canvas_file_B:"次重试获取画布文件",
      Retrying_to_get_canvas_file_C:"(最多",
      Retrying_to_get_canvas_file_D:"次)",
      Retrying_to_get_canvas_file_End:"无法检索画布文件，请关闭窗口并重试",
      Camera_Get_BC200_No:"目前已获取摄像机流，但未获取 BC-200 流。正在重试获取 BC-200 流。",
      Camera_No_BC200_Get:"已成功获取 BC-200 串流，但尚未获取摄像机串流。系统将重新尝试连接。	",
      Camera_No_BC200_NO:"目前未获取摄像机流和 BC-200 流。正在重试获取所有流。",
      Please_wait_for_the_camera_calibration_to_save: "请等待摄像机校准数据保存。",
      Camera_calibration_pan_tilt_is_not_save:"尚未保存此摄像机的校准资料。",
      Wait_Get_Sound_data: "请等待麦克风页面数据同步。",
      Wait_get_extension_setup_data: "请等待读取扩展设置数据。",
      Label_powerStandByModeMsg:"系统处于待机模式。请按电源按钮重新启动系统。", 
      Processing_Request:"正在处理请求。请稍候...",
      BLS_Parameters_Label: "参数",
      BLS_NoiseLevelThreshold_Label: "噪声阈值",
      BLS_NoiseLevelThreshold_Tooltip: "设置噪声阈值乘数。范围：100.0 ~ 300.0（100.0 适合安静环境，300.0 适合嘈杂环境）。",
      BLS_XAxisDistanceDiff_Label: "X轴位置变化阈值",
      BLS_XAxisDistanceDiff_Tooltip: "X轴位置变化的阈值。范围：10 ~ 50（10 检测小移动，50 忽略小范围移动）。",
      BLS_YAxisDistanceDiff_Label: "Y轴位置变化阈值",
      BLS_YAxisDistanceDiff_Tooltip: "Y轴位置变化的阈值。范围：10 ~ 50（10 检测小移动，50 忽略小范围移动）。",
      BLS_SoundIntensityDiff_Label: "声音强度变化阈值",
      BLS_SoundIntensityDiff_Tooltip: "声音强度变化的阈值。范围：1 ~ 5（1 检测小幅变化，5 忽略小波动）。",
      BLS_MicSelectionTime_Label: "麦克风选择时间",
      BLS_MicSelectionTime_Tooltip: "麦克风选择的最小时间间隔。范围：20 ~ 100（20 快速响应，100 高稳定性）。",
      BLS_HistorySize_Label: "历史记录大小",
      BLS_HistorySize_Tooltip: "分数历史记录窗口大小。范围：1 ~ 5（1 无平滑，5 强平滑）。",
      BLS_MicSwitchThreshold_Label: "麦克风切换阈值",
      BLS_MicSwitchThreshold_Tooltip: "麦克风切换的阈值。范围：0.9 ~ 1.3（0.9 易切换，1.3 高稳定性）。",
      BLS_DistanceWeight_Label: "距离权重",
      BLS_DistanceWeight_Tooltip: "距离在分数计算中的权重。范围：0.3 ~ 0.7（0.5 平衡，0.7 强调距离）。",
      BLS_SoundIntensityWeight_Label: "声音强度权重",
      BLS_SoundIntensityWeight_Tooltip: "声音强度在分数计算中的权重。范围：0.3 ~ 0.7（0.5 平衡，0.7 强调分贝）。",
      BLS_NumberOfInputs_Label: "输入特征数量",
      BLS_NumberOfInputs_Tooltip: "BLS模型输入特征数量。范围：9 ~ 12（9 简化模型，12 包括phiAngle）。",
      BLS_FeatureNodes_Label: "特征节点数量",
      BLS_FeatureNodes_Tooltip: "BLS模型特征节点数量。范围：6 ~ 16（6 低成本，16 高精度）。",
      BLS_EnhanceNodes_Label: "增强节点数量",
      BLS_EnhanceNodes_Tooltip: "BLS模型增强节点数量。范围：6 ~ 16（6 低成本，16 高精度）。",
      BLS_MaxTracksSize_Label: "最大跟踪数据数量",
      BLS_MaxTracksSize_Tooltip: "最大跟踪数据数量。范围：5 ~ 20（5 适合动态场景，20 适合静态场景）。",
      BLS_MicDataSaveWindowSize_Label: "麦克风数据窗口大小",
      BLS_MicDataSaveWindowSize_Tooltip: "历史分贝和位置数据的窗口大小。范围：3 ~ 10（3 适合动态场景，10 适合静态场景）。",
      Debug_Mode_Data_save:"等待调试模式数据保存。",
      BLS_Select_Environment: "选择环境",
      BLS_Select_Environment: "选择环境",
      BLS_Select_Environment_Default: "默认",
      BLS_Select_Environment_QuietOffice: "安静办公室",
      BLS_Select_Environment_NoisyCafe: "嘈杂咖啡厅",
      BLS_Select_Environment_ConferenceRoom: "会议室",
      BLS_Select_Environment_LargeLectureHall: "大型演讲厅",
      BLS_Select_Environment_OutdoorEvent: "户外活动",
      BLS_Select_Environment_RecordingStudio: "录音室",
      BLS_Select_Environment_TelemedicineClinic: "远程医疗诊所",
      BLS_Environment_Default_Tooltip: "特性：高噪声阈值 (200.0)，短距离差异 (20)，高距离权重 (0.8)，适应一般会议室或动态环境。调整原因：提供平衡设置，适合多数环境，强调空间定位以快速适应不同场景。",
      BLS_Environment_QuietOffice_Tooltip: "特性：低噪声阈值 (120.0)，中等距离差异 (25)，较高距离权重 (0.6)，快速麦克风选择 (40ms)。调整原因：优化安静环境，降低噪声敏感度以聚焦清晰语音，快速切换提升单人发言效率。",
      BLS_Environment_NoisyCafe_Tooltip: "特性：高噪声阈值 (200.0)，大距离差异 (40)，高声音强度权重 (0.6)，较长历史记录 (4)。调整原因：适应嘈杂环境，高阈值过滤背景噪声，强调声音强度以区分主要语音，增加稳定性。",
      BLS_Environment_ConferenceRoom_Tooltip: "特性：中等噪声阈值 (160.0)，中等距离差异 (35)，平衡权重 (0.5/0.5)，标准历史记录 (3)。调整原因：适合典型会议室，平衡噪声和定位需求，确保稳定切换和语音清晰度。",
      BLS_Environment_LargeLectureHall_Tooltip: "特性：较高噪声阈值 (180.0)，大距离差异 (45)，较多特征节点 (14)，大跟踪数据 (18)。调整原因：适应大型空间，允许更大移动范围，高精度模型支持多人远距离语音捕捉。",
      BLS_Environment_OutdoorEvent_Tooltip: "特性：极高噪声阈值 (220.0)，最大距离差异 (50)，高声音强度权重 (0.7)，最多跟踪数据 (20)。调整原因：应对户外噪声，忽略小范围移动，强调声音强度以捕捉主要语音，适合动态场景。",
      BLS_Environment_RecordingStudio_Tooltip: "特性：极低噪声阈值 (100.0)，小距离差异 (20)，高距离权重 (0.7)，最短历史记录 (1)。调整原因：优化高质量录音，极高灵敏度捕捉细微声音，快速响应和精确定位确保录音纯净。",
      BLS_Environment_TelemedicineClinic_Tooltip: "特性：低噪声阈值 (110.0)，小距离差异 (22)，较高距离权重 (0.65)，少量跟踪数据 (6)。调整原因：专为单人对话设计，低阈值确保清晰语音，精确定位和快速切换支持医疗对话。",
      Span_Import:"导入",
      Span_Export:"导出",
      Label_Debug_Mode:"调试模式",
      Label_Parameter_Mode:"参数调节模式",
      Label_Execution_Header:"执行消息",
      Span_Clear_Message:"清除调试消息",
      Span_Output_Message:"输出调试消息",
      Enter_file_name_to_save:"请输入您想要保存的文件名称。",
      Conversation_Rules:"对话模式规则",
      Position_Index: "位置",
      Enter_Switch_Time: "进入时间",
      Exit_Switch_Time: "退出时间",
      Enter_Switch_Count: "触发次数",
      Exit_Switch_Count: "静音次数",
      Control_Panel:"控制面板",
      Label_DisableSchedule: "关闭",
      Label_DailyRebootHint: "(Available when CamConnect is connected to a network and synchronized with an NTP server.)",
      Label_RebootTiming:"定时重启",
      Label_RebootTimingHint: "(Available when CamConnect is used without a network connection. Uses the system startup time for the reboot schedule.)",
      Label_PipMode: "PIP",
      Remember_Me:"记住我",
      User_Name:"用户名称",
      LogIn:"登入",
      Please_enter_your_username:"请输入您的使用者名称。",
      Please_enter_your_password:"请输入您的密码。",
      Username_saved:"账号已保存",
      Viewer_LogIn:"检视者 登入",
      Username_admin:"管理者",
      Username_viewer:"检视者",
      Login_Failed:"登入失败",
      Please_change_your_password:"请更改您的密码（'9999'除外）",
      Login_Invalid_username:"账号无效",
      Password_must_be_between_4_and_32_characters:"密码长度必须为 4 至 32 个字符。",
      Login_Wait3min:"您尝试登录的次数过多。出于安全考虑，系统目前不允许您登录。请等待 3 分钟，然后重试。",
      Login_Seconds_remaining:"剩余时间",
      Password_change_successfully:"密码已成功更改。",
      Password_change_failed:"密码更改失败。",
      Please_enter:"请输入",
      Please_re_enter_confirmPassword:'请再次输入您的密码。',
      Please_enter_currentPassword:'请输入您的密码。',
      Please_enter_newPassword:'请输入您的新密码。',
      File_is_validated:"文件已验证，正在发送至系统...",
      Error_File:"错误：上传处理失败",
      Calibration_data_sent_successfully:"校准数据发送成功！文件：",
      Cam_ConnectError_Hint:"注意：摄像机连线异常，请检查摄像机状态。",
      Username_must_be_between_4_and_32_characters:'账号必须为 4 到 32 个字符。',
      newPassword_confirmPassword_not_same:'您输入的确认密码与新密码不相符。',
      Current_password_is_incorrect:'您输入的当前密码不正确。',
      New_password_must_be_different_from_current_password:'新密码必须与当前密码不同',
      Wrong_password:"密码错误，还剩",
      Attempt_left:"次尝试机会",
      DeviceAPICertificate: "上传凭证档*",
      DeviceAPIPrivateKey: "上传私钥档*",
      DeviceAPITokens: "存取密钥(API 令牌)*",
      Browse_or_drop_a_file_here:"浏览或将档案拖放到此处",
      File_selected:"选定文件",
      Please_select_a_valid_certificate:"请选择有效的证书文件 (.crt)",
      Please_select_a_valid_private_key:"请选择一个有效的私钥文件（.key）",
      All_Zone_map: "区域映射概述",
      Label_EnableDirectorTooltip:"当启用智能导播时，语音跟踪将自动禁用。",
      Microphone_Zone_change_apply:'麦克风区域变更生效！',
      Enter_microphone_zone_editing_mode:'进入麦克风区域编辑模式',
      Enter_map_view_mode:'进入地图视图模式',
      All_microphone_information_visible: '所有麦克风信息均可见',
      Single_microphone_visible:'单个麦克风可见',
      Show_Microphone_Zone:'显示麦克风区域',
      Hide_Microphone_Zone:'隐藏麦克风区域',
    },
  };
  
  window.languages = languages;